<?php

declare(strict_types=1);

namespace App\Entity\Types;

use App\Entity\Alert\AlertTargetSpec;
use App\Entity\ConfigProfile\ConfigProfileKey;
use App\Entity\Product\ProductConf;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'typetable_value_types')]
#[ORM\Entity]
class TypesValueType
{
    
    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 64, unique: true, nullable: false)]
    public string $name;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'valType', targetEntity: ProductConf::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $productConfigs;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'valType', targetEntity: AlertTargetSpec::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $alertTargetSpecs;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'valueType', targetEntity: ConfigProfileKey::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id', referencedColumnName: 'id')]
    public Collection $configValueTypes;

    /**
     * ValueType constructor
     */
    public function __construct() {

        $this->productConfigs = new ArrayCollection();
        $this->alertTargetSpecs = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName(): string{

        return $this->name;

    }

}