<?php

declare(strict_types=1);

namespace App\Entity\Tool;

use App\Entity\Device;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'sms_history')]
#[ORM\Entity]
class SmsHistory
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 160, nullable: true)]
    public ?string $customText = null;

    /**
     * @var \DateTime
     */
    #[ORM\Column(type: Types::DATETIME_MUTABLE, options: ['default' => 'CURRENT_TIMESTAMP'])]
    public \DateTime $sent;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 20, nullable: true)]
    public ?string $destination = null;

    /**
     * @var Device|null
     */
    #[ORM\ManyToOne(targetEntity: Device::class, inversedBy: 'smsHistoryDevice')]
    #[ORM\JoinColumn(name: 'id_device', referencedColumnName: 'id_device')]
    public Device|null $device = null;

    /**
     * @var Device|null
     */
    #[ORM\ManyToOne(targetEntity: SmsTemplate::class, inversedBy: 'smsHistory')]
    #[ORM\JoinColumn(name: 'sms_id', referencedColumnName: 'id')]
    public SmsTemplate|null $smsTemplate = null;

    /**
     * Constructor.
     */
    public function __construct(){

        $this->sent = new \DateTime();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @param Device|null $device
     */
    public function setDevice(?Device $device): void
    {
        $this->device = $device;
    }

    /**
     * @return Device|null
     */
    public function getDevice(): ?Device
    {
        return $this->device;
    }

    /**
     * @return string|null
     */
    public function getCustomText(): ?string
    {
        return $this->customText;
    }

    /**
     * @param string|null $customText
     */
    public function setCustomText(?string $customText): void
    {
        $this->customText = $customText;
    }

    /**
     * @return string|null
     */
    public function getDestination(): ?string
    {
        return $this->destination;
    }

    /**
     * @param string|null $destination
     */
    public function setDestination(?string $destination): void
    {
        $this->destination = $destination;
    }

    /**
     * @return \DateTime
     */
    public function getSent(): \DateTime
    {
        return $this->sent;
    }

    /**
     * @param \DateTime $sent
     */
    public function setSent(\DateTime $sent): void
    {
        $this->sent = $sent;
    }

    /**
     * @return SmsTemplate|null
     */
    public function getSmsTemplate(): ?SmsTemplate
    {
        return $this->smsTemplate;
    }

    /**
     * @param SmsTemplate|null $smsTemplate
     */
    public function setSmsTemplate(?SmsTemplate $smsTemplate): void
    {
        $this->smsTemplate = $smsTemplate;
    }

}