<?php

namespace App\DataTable;

use App\Entity\Device\DeviceOsVersion;
use Sg\DatatablesBundle\Datatable\Column\ActionColumn;
use Sg\DatatablesBundle\Datatable\Column\BooleanColumn;
use Sg\DatatablesBundle\Datatable\Column\Column;
use Sg\DatatablesBundle\Datatable\Editable\SelectEditable;
use Sg\DatatablesBundle\Datatable\Filter\SelectFilter;

/**
 * Class FirmwareDatatable
 * @package App\Datatables
 */
class FirmwareDatatable extends BaseDatatable
{

    protected string $entity = DeviceOsVersion::class;
    protected string $name = 'firmware_datatable';

    /**
     * {@inheritdoc}
     */
    public function buildDatatable(array $options = []): void
    {

        $osTypes = $options['osTypes'];
        $osVersions = $options['osVersions'];

        parent::buildDatatable($options);

        $this->extensions->set([
            'buttons' => [
                'create_buttons' => [  // custom buttons
                    [
                        'action' => [
                            'template' => '/datatable/firmware/addFirmware.js.twig',
                        ],
                        'class_name' => 'btn-add',
                        'name' => 'addFw',
                        'text' => '<i class=\"fa fa-plus\"></i> Add Firmware',
                    ],
                    $this->getRefreshButton()
                ],
            ]
        ]);

        $this->addIdColumn();

        $this->columnBuilder
            ->add('osType.name', Column::class, [
                'title' => 'Os Type',
                'width' => '100%;',
                'filter' => array(SelectFilter::class, [
                    'classes' => '',
                    'search_type' => 'eq',
                    'multiple' => false,
                    'select_options' => array('' => 'Any') + $this->getOptionsArrayFromEntities($osTypes, 'name', 'name'),
                    'cancel_button' => true,
                ])
            ])
            ->add('version', Column::class, [
                'title' => 'Version',
                'width' => '100%;',
                'filter' => array(SelectFilter::class, [
                    'classes' => '',
                    'search_type' => 'eq',
                    'multiple' => false,
                    'select_options' => array('' => 'Any') + $this->getOptionsArrayFromEntities($osVersions, 'description', 'description'),
                    'cancel_button' => true,
                ])
            ])
            ->add('available', BooleanColumn::class, [
                'title' => 'Available',
                'width' => '100%;',
                'true_label' => 'Yes',
                'false_label' => 'No',
                'true_icon' => 'fa fa-check green',
                'false_icon' => 'fa fa-times-circle red',
                'filter' => [SelectFilter::class, [
                        'search_type' => 'eq',
                        //'multiple' => true,
                        'select_options' => [
                            '' => 'Any',
                            '1' => 'Yes',
                            '0' => 'No',
                        ],
                        'cancel_button' => true,
                    ]
                ],
            ])
            ->add('approved', BooleanColumn::class, [
                'title' => 'Approved',
                'default_content' => '',
                'width' => '100%;',
                'true_label' => ' Yes',
                'true_icon' => 'fa fa-check green',
                'false_icon' => 'fa fa-times-circle red',
                'false_label' => ' No',
                'filter' => [SelectFilter::class, [
                        'search_type' => 'eq',
                        //'multiple' => true,
                        'select_options' => [
                            '' => 'Any',
                            '1' => 'Yes',
                            '0' => 'No',
                        ],
                        'cancel_button' => true,
                    ]
                ],
                'editable' => [SelectEditable::class, [
                        'editable_if' => function ($row) {
                            if ($this->getUser()) {
                               // if ($row['createdBy']['id'] == $this->getUser()->getId() or true === $this->isAdmin()) {
                                    return true;
                               // };
                            }

                            return false;
                        },
                        'source' => [
                            array('value' => 1, 'text' => 'Yes'),
                            array('value' => 0, 'text' => 'No'),
                        ],
                        'mode' => 'inline',
                        'empty_text' => '',
                    ],
                ],
            ])
            ->add('Devices_count', Column::class, [
                'title' => 'Devices count',
                'width' => '100%;',
                'dql' => '(SELECT COUNT({p}) FROM App:Device\Device {p} WHERE {p}.osVer = deviceosversion.id)',
                'searchable' => true,
                'orderable' => true,
            ])
            ->add(null, ActionColumn::class, array(
                'title' => $this->translator->trans('sg.datatables.actions.column_name'),
                'width' => '100%;',
                'class_name' => 'row_device_actions',
                'actions' => array(
                    array(
                        'route' => 'admin_firmware_detail',
                        'route_parameters' => array(
                            'fwId' => 'id',
                        ),
                        'label' => '' . $this->translator->trans('sg.datatables.actions.detail'),
                        'icon' => self::ICON_LIST,
                        'attributes' => array(
                            'rel' => 'tooltip',
                            'title' => $this->translator->trans('sg.datatables.actions.detail'),
                            'class' => 'btn btn-primary btn-xs',
                            'role' => 'button',
                        ),
                    ),

                ),
            ))

        ;
    }

}