#!/bin/bash
if [[ $# -ne 1 || "$1" != "${1//[^0-9]}" ]] ; then
	echo "Usage: call with one parameter (local port), I will try to kill process that is listening there."
	exit 1
fi
[ -z "$C_SS" ] && C_SS=$(command -v ss)
RES=$(sudo $C_SS -lptn4H "sport = :$1 src = 127.0.0.1")
if [ 0 -ne $? ] ; then
	echo "Unable to execute sudo ss."
	exit 2
fi
MATCH=$(echo $RES | grep "\"sshd\",pid=")
if [ -z "$MATCH" ] ; then
	echo "Unable to locate the process."
	exit 3
fi
PIDTOKILL=$(echo $RES | sed "s/.*,pid=\([0-9]*\).*/\1/")
echo "PID is $PIDTOKILL"
kill $PIDTOKILL
RES=$?
if [ 0 -eq $RES ] ; then
	exit 0
else
	echo "Unable to kill process $PIDTOKILL"
	exit 4
fi
