<?php

declare(strict_types=1);

namespace App\Entity\Device;

use App\Entity\CustomScript\CustomScriptDevTypeMap;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'device_types')]
#[ORM\Entity]
class DeviceType
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 64, nullable: false)]
    public string $name;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'devType', targetEntity: Device::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'dev_type')]
    public Collection $devices;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'devType', targetEntity: DeviceOsType::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $deviceOsTypes;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'deviceType', targetEntity: DeviceTypeAgentMapping::class, cascade: ['persist', 'remove'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $deviceTypeAgentMappings;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'devType', targetEntity: CustomScriptDevTypeMap::class, cascade: ['persist', 'remove'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $deviceTypeCustomScriptMappings;

    /**
     * DeviceType constructor
     */
    public function __construct(){

        $this->devices = new ArrayCollection();
        $this->deviceTypeAgentMappings = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getName(): string {

        return $this->name;

    }

    /**
     * @return ArrayCollection
     */
    public function getDevices(): ArrayCollection {

        return $this->devices;

    }

    /**
     * @return Collection
     */
    public function getDeviceTypeAgentMapping() {

        return $this->deviceTypeAgentMappings;

    }

}