<?php

declare(strict_types=1);

namespace App\Service\Api;

final class DashboardLights extends ApiService
{

    private const PARAM_MONITORING_GROUP_ID = 'mgid';
    private const PARAM_SUBSET_ID = 'mgsset';

    private const URL_API_GET_DASHBOARD_DETAIL = '/g/mgget';

    /**
     * @param int $monitoringGroupId
     * @param int $subsetId
     * @return false|mixed
     */
    public function getDashboardDetailData(int $monitoringGroupId, int $subsetId){

        $urlParams = self::PARAM_MONITORING_GROUP_ID . '=' . $monitoringGroupId;
        $urlParams .= '&'. self::PARAM_SUBSET_ID .'=' . $subsetId;

        $result = $this->getApiCall($this->baseUrl . self::URL_API_GET_DASHBOARD_DETAIL . '?' . $urlParams);

        if($result && $result->operation_result->Code === 0){

            return $result->subsect_list;

        }

        return [];

    }

}