<?php

declare(strict_types=1);

namespace App\Entity\Tunnel;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'tunnel_op')]
#[ORM\Entity]
class TunnelOperation
{

    final public const OPERATION_NONE = 'NONE';
    final public const OPERATION_SETUP = 'SETUP';
    final public const OPERATION_SHUTDOWN = 'SHUTDOWN';
    final public const OPERATION_RESTART = 'RESTART';

    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 32, unique: true, nullable: false)]
    public string $name;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'requestedOperation', targetEntity: Tunnels::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $tunnelOperations;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'operation', targetEntity: TunnelOperationStatusMapping::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $operationStatusMapping;

    /**
     * TunnelOperation constructor.
     */
    public function __construct() {

        $this->tunnelOperations = new ArrayCollection();
        $this->operationStatusMapping = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getName(): string {

        return $this->name;

    }

}