<?php

namespace App\Form\Device;

use App\Entity\Device\Device;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

class FwVersionType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {

        $osVersions = $options['data']['osVersions'];
        $showNoSpecific = $options['data']['showNoSpecific'];
        /** @var Device $device */
        $device = $options['data']['device'];

        $choices = [];

        foreach ($osVersions as $version) {
            $choices[$version->getVersion()] = $version->getId();
        }
        if ($osVersions) {
            $builder
                ->add('fw_version', ChoiceType::class, [
                    'choices' => $choices,
                    'data' => (!is_null($device->getOsVer())) ? $device->getOsVer()->getId() : null,
                    'attr' => ['class' => 'form-control-sm'],
                ])
                ->add('save', SubmitType::class, [
                    'label' => '<i class="fas fa-file-arrow-up"></i> Set version',
                    'label_html' => true,
                    'attr' => ['class' => 'btn-primary btn-sm'],
                    'block_prefix' => 'modal_footer'
                ])
            ;
        }

        if ($showNoSpecific) {
            $builder->add('no_specific', SubmitType::class, [
                'label' => '<i class="fas fa-remove"></i> Set to No specific version',
                'label_html' => true,
                'attr' => ['class' => 'btn-secondary btn-sm'],
            ]);
        }
    }
}
