#!/usr/bin/bash

BASEDEFS="base_defs"

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

. "$DIR"/"$BASEDEFS" || { echo "Fatal: Definition file ($BASEDEFS) not found."; exit 1; }
. "$DIR"/"$BASEFUNCS" || { echo "Fatal: Basic functions ($BASEFUNCS) not found."; exit 1; }
[ -f "$DWARFG_SITECONF" ] && . "$DWARFG_SITECONF"

TARGETFILE="$GUIDIR/public/mevents.rss"
TSTFILE="$SRVDIR_SRV/rss_timestamp.txt"

if [ -f "$TSTFILE" ] ; then
	OLD_MAXID=$(head -1 "$TSTFILE")
else
	OLD_MAXID=""
fi

if [ -n "$DBPASS" ] ; then
	MYSQOPT="--password=$DBPASS -Nse"
else
	MYSQOPT="-Nse"
fi

MAXID=$(mysql "$DWARFG_DBN" $MYSQOPT "SELECT MAX(id) FROM log_events;")
DOMIP=$(mysql "$DWARFG_DBN" $MYSQOPT "SELECT strval FROM product_conf WHERE name='ExternalURL';")
RFCDATE=$(date -R)
echo "MAXID=\"$MAXID\""
echo "OLD_MAXID=\"$OLD_MAXID\""
[[ -n "$OLD_MAXID" && "$MAXID" = "$OLD_MAXID" ]] && {
	echo "No new events..."
	exit 0
}
LCOUNTER=0
while IFS=$'\t' read S_TIME S_EVNAME S_VAL S_EID S_MSG; do
	#echo -e "S_TIME=\"$S_TIME\"\nS_EVNAME=\"$S_EVNAME\"\nS_VAL=\"$S_VAL\"\nS_EID=\"$S_EID\"\nS_MSG=\"$S_MSG\""
	[ 0 -eq $LCOUNTER ] && {
		# write header
		echo '<?xml version="1.0" encoding="utf-8"?>' >"$TARGETFILE"
		echo -e "<rss version=\"2.0\">\n\t<channel>\n\t\t<title>$NAME at $DOMIP RSS</title>\n\t\t<link>https://$DOMIP/rss</link>\n\t\t<description>Event log feed for $NAME installation at $DOMIP.</description>\n\t\t<language>en</language>\n\t\t<lastBuildDate>$RFCDATE</lastBuildDate>" >>"$TARGETFILE"
	}
	# generate description
	DESC=""
	[[ -n "$S_MSG" && "NULL" != "$S_MSG" ]] && DESC="$S_MSG "
	[[ -n "$S_VAL" && "NULL" != "$S_VAL" ]] && DESC="${DESC}num=$S_VAL "
	[[ -n "$S_EID" && "NULL" != "$S_EID" ]] && DESC="${DESC}eid=$S_EID"
	[ -n "$DESC" ] && DESC="\n\t\t\t<description>$DESC</description>"
	# write item
	echo -e "\t\t<item>\n\t\t\t<title>$S_EVNAME</title>$DESC\n\t\t</item>" >>"$TARGETFILE"
	LCOUNTER=$((LCOUNTER+1))
done < <(mysql "$DWARFG_DBN" $MYSQOPT "SELECT log_events.time, log_event_type.name, log_events.value, log_events.extra_id, log_events.msg FROM log_events JOIN log_event_type ON log_events.evtype = log_event_type.id ORDER BY time DESC limit 100;")
# write footer
echo -e "\t</channel>\n</rss>" >>"$TARGETFILE"
# update timestamp
echo "$MAXID" >$TSTFILE
