<?php

declare(strict_types=1);

namespace App\Entity\ConfigProfile;

use App\Entity\Device\Device;
use App\Entity\Device\DeviceOsVersion;
use App\Entity\Device\FwFileName;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'config_profiles')]
#[ORM\Entity]
class ConfigProfile
    {
    /**
	 *
     * @var int|null
     */
    #[ORM\Column(name: 'id', type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 64, nullable: true)]
    public string $name;

    /**
     * @var Device
     */
    #[ORM\OneToOne(inversedBy: 'configProfileAutomatic', targetEntity: Device::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'automatic', referencedColumnName: 'id_device', nullable: true)]
    public Device $automatic;

    /**
     * @var bool
     */
    #[ORM\Column(type: 'boolean', nullable: false, options: ['default' => false])]
    public bool $defaults;

    /**
     * @var bool
     */
    #[ORM\Column(type: 'boolean', nullable: false, options: ['default' => true])]
    public bool $directive;

    /**
     * @var DeviceOsVersion
     */
    #[ORM\ManyToOne(targetEntity: DeviceOsVersion::class, inversedBy: 'configProfiles')]
    #[ORM\JoinColumn(name: 'os_version', referencedColumnName: 'id')]
    public DeviceOsVersion $osVersion;

    /**
     * @var FwFileName
     */
    #[ORM\ManyToOne(targetEntity: FwFileName::class, inversedBy: 'configProfiles')]
    #[ORM\JoinColumn(name: 'fwfname', referencedColumnName: 'id')]
    public FwFileName $fwfname;

	/**
	 * @var bool
	 */
	#[ORM\Column(type: 'boolean', nullable: false, options: ['default' => false])]
	public bool $deleted;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'configProfile', targetEntity: Device::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id', referencedColumnName: 'id')]
    public Collection $devices;

    /**
     * ConfigProfile constructor
     */
    public function __construct(){

       $this->devices = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getName(): ?string {

        return $this->name;

    }

    /**
     * @return Device
     */
    public function getAutomatic(): ?Device {

        return $this->automatic;

    }

	/**
	 * @return bool
	 */
	public function isDeleted(): bool
	{
		return $this->deleted;
	}

	/**
	 * @param bool $deleted
	 */
	public function setDeleted(bool $deleted): void
	{
		$this->deleted = $deleted;
	}

	/**
	 * @return bool
	 */
	public function isDirective(): bool
	{
		return $this->directive;
	}

}