<?php

namespace App\Repository;

use App\Entity\MonitoringGroup\MonitoringGroup;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method MonitoringGroup|null find($id, $lockMode = null, $lockVersion = null)
 * @method MonitoringGroup|null findOneBy(array $criteria, array $orderBy = null)
 * @method MonitoringGroup[]    findAll()
 * @method MonitoringGroup[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class MonitoringGroupRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, MonitoringGroup::class);
    }

    /**
     * @return float|int|mixed|string
     */
    public function getAllMonitoringGroups(){

        return $this->createQueryBuilder('p')
            ->where('p.id != :val')
            ->setParameter('val', 1)
            ->getQuery()
            ->getResult()
            ;

    }

}
