<?php

declare(strict_types=1);

namespace App\Entity\Label;

use App\Entity\Device\Device;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'system_labels_map')]
#[ORM\UniqueConstraint(name: 'device_label', columns: ['id_device', 'id_system_label'])]
#[ORM\Entity]
class SystemLabelDeviceMap
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;
    /**
     * @var int
     */
    #[ORM\Column(name: 'id_system_label', type: 'integer')]
    private readonly int $labelId;


    /**
     * @var SystemLabel
     */
    #[ORM\ManyToOne(targetEntity: SystemLabel::class, inversedBy: 'devices')]
    #[ORM\JoinColumn(name: 'id_system_label', referencedColumnName: 'id')]
    public SystemLabel $systemLabel;

    /**
     * @var Device
     */
    #[ORM\ManyToOne(targetEntity: Device::class, inversedBy: 'systemLabels')]
    #[ORM\JoinColumn(name: 'id_device', referencedColumnName: 'id_device')]
    public Device $device;

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return int
     */
    public function getLabelId(): int {

        return $this->labelId;

    }

    /**
     * @return Label
     */
    public function getSystemLabel(): SystemLabel
    {
        return $this->systemLabel;
    }

    /**
     * @param Label $systemLabel
     */
    public function setSystemLabel(SystemLabel $systemLabel): void
    {
        $this->systemLabel = $systemLabel;
    }

    /**
     * @return Device
     */
    public function getDevice(): Device {

        return $this->device;

    }

    /**
     * @return void
     */
    public function setDevice(Device $device): void {

        $this->device = $device;

    }

}