<?php

declare(strict_types=1);

namespace App\Entity\Device;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'device_os_types')]
#[ORM\Entity]
class DeviceOsType
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 64, unique: true, nullable: false)]
    public string $name;

    /**
     * @var DeviceType|null
     */
    #[ORM\ManyToOne(targetEntity: DeviceType::class, inversedBy: 'deviceOsTypes')]
    #[ORM\JoinColumn(name: 'dev_type')]
    public ?DeviceType $devType = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 64, unique: true, nullable: false)]
    public ?string $directoryName = null;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'osType', targetEntity: DeviceOsVersion::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $osVersions;

    /**
     * OsType constructor
     */
    public function __construct() {

        $this->osVersions = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName(): string{

        return $this->name;

    }

    /**
     * @return string
     */
    public function getDirectoryName(): ?string
    {
        return $this->directoryName;
    }

    /**
     * @return DeviceType|null
     */
    public function getDevType(): ?DeviceType {

        return $this->devType;

    }

}