<?php

declare(strict_types=1);

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'tunnel_web')]
#[ORM\Entity]
class TunnelWeb
{

    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var Device
     */
    #[ORM\ManyToOne(targetEntity: \App\Entity\Device::class, inversedBy: 'webTunnels')]
    #[ORM\JoinColumn(name: 'id_device', referencedColumnName: 'id_device')]
    public Device $device;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 32, nullable: true, unique: true)]
    public string $url;

    /**
     * @var int
     */
    #[ORM\Column(type: 'integer', nullable: true)]
    public int $devicePort;

    /**
     * @var \DateTime
     */
    #[ORM\Column(type: 'datetime', options: ['default' => null])]
    public \DateTime $requestTime;

    /**
     * @var \DateTime
     */
    #[ORM\Column(type: 'datetime', options: ['default' => null])]
    public \DateTime $expectedTime;

    /**
     * @var \DateTime
     */
    #[ORM\Column(type: 'datetime', options: ['default' => null])]
    public \DateTime $setupTime;

    /**
     * @var \DateTime
     */
    #[ORM\Column(type: 'datetime', options: ['default' => null])]
    public \DateTime $lastTransfer;

    #[ORM\ManyToOne(targetEntity: \App\Entity\TunnelStatus::class, inversedBy: 'tunnelStatuses')]
    #[ORM\JoinColumn(name: 'status')]
    public TunnelStatus $status;

    /**
     * @var TunnelOperation
     */
    #[ORM\ManyToOne(targetEntity: \App\Entity\TunnelOperation::class, inversedBy: 'tunnelOperations')]
    #[ORM\JoinColumn(name: 'requested_op')]
    public TunnelOperation $requestedOperation;

    /**
     * TunnelWeb constructor.
     */
    public function __construct() {

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getUrl(): string {

        return $this->url;

    }

    /**
     * @return Device
     */
    public function getDevice(): ?Device {

        return $this->device;

    }

    public function setDevice(Device $device): void
    {
        $this->device = $device;
    }

    /**
     * @return TunnelStatus
     */
    public function getStatus(): TunnelStatus {

        return $this->status;

    }

    /**
     * @return TunnelOperation
     */
    public function getRequestedOperation(): TunnelOperation {

        return $this->requestedOperation;

    }

    public function setRequestedOperation(TunnelOperation $requestedOperation): void {

        $this->requestedOperation = $requestedOperation;

    }

}