<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

class SystemStatusType extends AbstractType
{

    const SERVICE_STATUS_ACTIVE = 'active';
    const SERVICE_STATUS_INACTIVE = 'inactive';

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options){

        $status = str_replace("\n","",$options['data']['status']);

        if($status === self::SERVICE_STATUS_ACTIVE){

            $builder->add('restart', SubmitType::class, ['label' => '<i class="fas fa-retweet"></i> Restart', 'label_html' => true]);

        }else{

            $builder->add('start', SubmitType::class, ['label' => '<i class="fas fa-play"></i> Start', 'label_html' => true]);

        }

    }

}