#!/bin/bash
SCRIPT="index.cgi"
SRC="/opt/adwarfg/www/cgi_common.sh"

. $SRC

echo "Content-type: text/html"
echo "Cache-Control: no-cache"
echo "Pragma: no-cache"
echo ""
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">"
echo "<html>"
echo "<head>"
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">"
echo "<meta http-equiv=\"Content-Style-Type\" content=\"text/css\">"
echo "<meta http-equiv=\"Content-Script-Type\" content=\"text/javascript\">"
echo "<title>Dwarfguard Agent</title>"
echo "<style type="text/css">"
echo "<!--"
echo "body, table, tr, td, a {"
echo "  font-size: 12px; font-family: Verdana, Arial, Helvetica, sans-serif;"
echo "}"
echo "form, input {"
echo "  margin: 0px;"
echo "}"
echo "pre {"
echo "  margin: 10px 0px 10px 0px;"
echo "}"
echo "h2 {"
echo "  font-size: 24px; margin-bottom: 3px;"
echo "}"
echo "a {"
echo "  color: #0033CC; text-decoration: none;"
echo "}"
echo "a:hover {"
echo "  text-decoration: underline;"
echo "}"
echo ".logo {"
echo "  color: #000080; text-shadow: #B0C0E0 2px 2px 2px; filter: shadow(color=#B0C0E0, direction=145, strength=4);"
echo "}"
echo ".window {"
echo "  background-color: #F4F4F4;"
echo "}"
echo ".title {"
echo "  color: #FFFFFF; background-color: #000080; border-color: #000080; font-weight: bold;"
echo "}"
echo ".header {"
echo "  color: #000000; background-color: #C8D8FF;"
echo "}"
echo ".input {"
echo "  width: 165px;"
echo "}"
echo "-->"
echo "</style>"
echo "</head>"
echo "<body bgcolor=\"#FFFFFF\">"
echo "<center>"
echo "<form name=\"f\" action=\"\">"
echo "<table cellspacing=\"0\" cellpadding=\"5\" border=\"3\" class=\"window\">"
echo "  <tr>"
echo "    <td bgcolor=\"#008000\" align=\"center\"><font color=\"#FFFFFF\"><b>Dwarfguard module update</b></font></td>"
echo "  </tr>"
echo "  <tr>"
echo "    <td>"

 
 if [ "$REQUEST_METHOD" = "POST" ]; then
    if [ "$CONTENT_LENGTH" -gt 0 ]; then
        read -n $CONTENT_LENGTH POST_DATA <&0
    fi

    #echo "$POST_DATA" 
    LOCATION_REDIRECT='index.cgi'
    NEWADDR=$(echo "$POST_DATA" | sed -n 's/^.*address=\([^&]*\).*$/\1/p' | sed "s/%20/ /g")
    BUTTON=$(echo "$POST_DATA" | sed -n 's/^.*button=\([^&]*\).*$/\1/p' | sed "s/+/ /g")
    LOGLEVELPRESET=$(echo "$POST_DATA" | sed -n 's/^.*loglevel_preset=\([^&]*\).*$/\1/p' | sed "s/%20/ /g")
    
    if [ "$BUTTON" ]; then
        echo "<p>Processing command $BUTTON...</p>"
    fi

     if [ "$LOGLEVELPRESET" ]; then
        LOCATION_REDIRECT='loglevels.cgi'
    fi

    case $BUTTON in
              "SetServer")
                if [[ -n "$NEWADDR" && "$NEWADDR" != "$g_serverurl" ]] ; then
                  echo "<p>NEW address: <b>" "$NEWADDR" "</b></p>"
                  echo "g_serverurl=$NEWADDR" >"$SETTINGS_SA"
                  echo "Restarting Dwarfguard Agent..."
                  echo "<p>"
                  $DWARFG_INIT stop
                  echo "</p><p>"
                  $DWARFG_INIT start
                  echo "</p>"
                  g_serverurl="$NEWADDR"
                fi
                ;;
              "Stop Agent")
                echo "<p> Stopping Dwarfguard agent... </p>"
                $DWARFG_INIT stop
                ;;
              "Start Agent")
                echo "<p> Starting Dwarfguard agent... </p>"
                $DWARFG_INIT start
                ;;
               "Sync to server Now")
                echo "<p> Syncing data to the server... </p>"
                $AGENT expedite
                ;;
            esac
            
    case $LOGLEVELPRESET in
        "LogNone")
            g_alevel_debug=3
            g_alevel_log=4
            g_alevel_syslog=6
            echo "<p> Changing log level: only errors will be logged.</p>"
            export_loglevel
            ;;
        "LogInfo")
            g_alevel_debug=3
            g_alevel_log=3
            g_alevel_syslog=5
            echo "<p> Changing log level: basic information messages will be logged.</p>"
            export_loglevel
            ;;
        "LogVerbose")
            g_alevel_debug=2
            g_alevel_log=2
            g_alevel_syslog=4
            echo "<p> Changing log level: verbose logging will be switched on.</p>"
            export_loglevel
            ;;
        "LogAll")
            g_alevel_debug=1
            g_alevel_log=1
            g_alevel_syslog=3
            echo "<p> Changing log level: debug messages will be logged.</p>"
            export_loglevel
            ;;
    esac

fi

#echo "       <tr align=\"center\">"
#echo "          <td>Configuration successfully updated.</td>"
#echo "        </tr>"
echo "        <tr align=\"center\">"
echo "          <td id=\"button\"><input type=\"button\" name=\"button\" value=\"Back\" onclick=\"location.href='$LOCATION_REDIRECT'\">"
echo "        </tr>"
echo 
echo "    </td>"
echo "  </tr>"
echo "</table>"
echo "</form>"
echo "</center>"

echo "</body>"
echo "</html>"

exit 0
