<?php

declare(strict_types=1);

namespace App\Controller\Admin\Manager;

use App\Bundles\Sg\DatatablesBundle\Response\DatatableResponse;
use App\Controller\Admin\BaseController;
use App\Datatables\SwPackageDatatable;
use App\Entity\UserModule;
use App\Exception\UserModuleNotFoundException;
use App\Service\DatatableService;
use Doctrine\Persistence\ManagerRegistry;
use Sg\DatatablesBundle\Datatable\DatatableFactory;
use Sg\DatatablesBundle\Response\DatatableQueryBuilder;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\Response;

class SwPackageController extends BaseController
{
    /**
     * @return Response
     * @throws \Exception
     */
    #[Route(path: '/admin/sw-packages', name: 'admin_sw_package')]
    public function default(Request $request, ManagerRegistry $managerRegistry,
                            DatatableFactory $factory, DatatableResponse $responseService): Response{

        $isAjax = $request->isXmlHttpRequest();
        $this->filter = $request->query->get('column');

        $userModules = $managerRegistry->getRepository(UserModule::class)->findAll();

        $datatable = $factory->create(SwPackageDatatable::class);
        $datatable->buildDatatable(['userModules' => $userModules]);

        if ($isAjax) {
            $responseService->setDatatable($datatable);

            $requestParams = $this->getDatatableFilter($request, $datatable);
            $datatableQueryBuilder = new DatatableQueryBuilder($requestParams, $datatable);
            $responseService->setDatatableQueryBuilder($datatableQueryBuilder);

            $qb = $datatableQueryBuilder->getQb();
            $qb->where('usermodule.hidden = :hidden');
            $qb->setParameter('hidden', '0');

            return $responseService->getResponse();
        }

        return $this->render('manager/swPackage/index.twig', ['datatable' => $datatable, 'filter' => $this->filter]);

    }

    /**
     * @param DatatableFactory $factory
     * @return \Symfony\Component\HttpFoundation\JsonResponse|Response
     * @throws \Exception
     */
    #[Route(path: '/admin/sw-packages/{userModuleId}', name: 'admin_sw_package_device_list')]
    public function showDetail(Request $request, ManagerRegistry $managerRegistry,
                                          DatatableService $datatableService, DatatableResponse $responseService,
                                          int $userModuleId)
    {

        $isAjax = $request->isXmlHttpRequest();
        $this->filter = $request->query->get('column');

        $userModule = $managerRegistry->getRepository(UserModule::class)->find($userModuleId);

        if(!$userModule){

            throw new UserModuleNotFoundException();

        }

        $datatable = $datatableService->getDeviceDatatable();

        if ($isAjax) {
            $responseService->setDatatable($datatable);

            $requestParams = $this->getDatatableFilter($request, $datatable);
            $datatableQueryBuilder = new \App\Bundles\Sg\DatatablesBundle\Response\DatatableQueryBuilder($requestParams, $datatable);
            $responseService->setDatatableQueryBuilder($datatableQueryBuilder);

            $qb = $datatableQueryBuilder->getQb();
            $qb->join('App:DeviceUserModule', 'dum',\Doctrine\ORM\Query\Expr\Join::WITH,
                'vdevice.id = dum.device');
            $qb->andWhere('dum.userModule = :id');
            $qb->andWhere('vdevice.deleted = :deleted');
            $qb->setParameter('deleted', '0');
            $qb->setParameter('id', $userModuleId);

            return $responseService->getResponse();
        }

        return $this->render('manager/swPackage/detail.html.twig', ['datatable' => $datatable, 'filter' => $this->filter, 'userModule' => $userModule]);

    }

}