<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\Type;

class AuthProfileType extends AbstractType
{

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $authProfile = $options['data']['authProfile'] ?? null;

        $builder
            ->add('profileName', TextType::class, [
                'constraints' => [
                    new Type('string'),
                ],
                'label' => 'Profile Name',
                'required' => false,
                'block_prefix' => 'modal_body',
            ])
            ->add('username', TextType::class, [
                'constraints' => [
                    new NotBlank(),
                    new Type('string'),
                ],
                'label' => 'Username <strong>*</strong>',
                'label_html' => true,
                'required' => true,
                'block_prefix' => 'modal_body',
            ]);

        $array = [
            'label' => 'SSH Password',
            'block_prefix' => 'modal_body',
            'required' => false,
        ];

        /*$array = [
            'label' => 'SSH Password',
            'block_prefix' => 'modal_body',
            'required' => false,
            'type' => PasswordType::class,
            'invalid_message' => 'The password fields must match.',
            'options' => ['attr' => ['class' => 'password-field']],
            'first_options'  => [
                'label' => 'Password',
                //'block_prefix' => 'modal_body',
                'row_attr' => [
                    'class' => 'modal_body',
                ]
            ],
            'second_options' => [
                'label' => 'Repeat Password',
                //'block_prefix' => 'modal_body',
            ],
        ];*/

        if ($authProfile && !empty($authProfile->getSshPwd())) {
            $array['attr'] = ['placeholder' => '******'];
        }

        //$builder->add('sshPwd', RepeatedType::class, $array);
        $builder->add('sshPwd', PasswordType::class, $array);

        $labelSshKey = 'SSH Key';
        if(!empty($authProfile->sshKey)){

            $labelSshKey = '<b>SSH Key is defined.</b> You can input the new one to override.';

        }

        $builder
            ->add('sshKey', TextareaType::class, [
                'constraints' => [
                    new Type('string'),
                ],
                'label' => $labelSshKey,
                'label_html' => true,
                'data' => '',
                'required' => false,
                'block_prefix' => 'modal_body',
            ])
            ->add('save', SubmitType::class, [
                'label' => (isset($authProfile) && $authProfile->getId()) ? '<i class="fas fa-floppy-disk"></i> Update' : '<i class="fas fa-plus"></i> Add Auth Profile',
                'label_html' => true,
                'block_prefix' => 'form_footer',
                'attr' => ['data-row-class' => 'alert_targetDevice', 'class' => 'btn btn-primary float-right'],
            ]);

        $builder->get('sshPwd')->setAttributes(['placeholder' => '******']);
    }

}
