<?php

declare(strict_types=1);

namespace App\Entity\DataChangeLog;

use App\Entity\DataChangeLog;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'data_change_source')]
#[ORM\Entity]
class DataChangeSource
{

    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 64, unique: true, nullable: false)]
    public string $name;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'source', targetEntity: DataChangeLog\DataChangeLog::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $sources;

    /**
     * EventSource constructor
     */
    public function __construct(){

        $this->sources = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getName(): string {

        return $this->name;

    }

}