<?php

namespace App\Repository;

use App\Entity\Types\TypesValueType;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method TypesValueType|null find($id, $lockMode = null, $lockVersion = null)
 * @method TypesValueType|null findOneBy(array $criteria, array $orderBy = null)
 * @method TypesValueType[]    findAll()
 * @method TypesValueType[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class TypesValueTypeRepository extends ServiceEntityRepository
{

    /**
     * @param ManagerRegistry $registry
     */
    public function __construct(ManagerRegistry $registry){

        parent::__construct($registry, TypesValueType::class);

    }

    public function getAllTypes(): array{

        return $this
            // database table alias
            ->createQueryBuilder( 'TypesValueType' )
            // first parameter should be alias and second parameter will be column name, which you want to show as array index
            ->indexBy('TypesValueType','TypesValueType.id')
            // get query
            ->getQuery()
            // get doctrine result in array format
            ->getArrayResult();

    }

}