<?php

namespace App\Form\Device;

use App\Entity\Label;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

class DeviceSystemLabelType extends AbstractType
{

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options){

        /** @var Label $deviceLabels */
        $deviceLabels = $options['data']['deviceLabels'];
        $labels = $options['data']['labels'];

        $selectedItems = [];

        foreach ($deviceLabels as $item) {
            $selectedItems[] = $item->getLabelId();
        }

        $choices = [];

        foreach ($labels as $item) {

            $choices[$item->getLabel()] = $item->getId();

        }

        $builder
            ->add('labels', ChoiceType::class ,array(
                'choices' => $choices,
                'placeholder' => 'Select a Device to clone from',
                'multiple' => true,
                'required' => false,
                'data' => $selectedItems,

            ))
            ->add('save', SubmitType::class, ['label' => 'Set ',
                'block_prefix' => 'modal_footer'])
        ;

    }

}