<?php

namespace App\EventSubscriber;

use App\Event\MonitoringGroupCreateEvent;
use App\Repository\MonitoringGroupRepository;
use Doctrine\ORM\EntityManagerInterface;
use Psr\Log\LoggerInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class MonitoringGroupSubscriber implements EventSubscriberInterface
{
    private $logger;

    private $entityManager;

    private $monitoringGroupRepository;

    public function __construct(LoggerInterface $logger, EntityManagerInterface $entityManager,
                                MonitoringGroupRepository $monitoringGroupRepository)
    {
        $this->logger = $logger;
        $this->entityManager = $entityManager;
        $this->monitoringGroupRepository = $monitoringGroupRepository;
    }

    public static function getSubscribedEvents()
    {
        return [
            MonitoringGroupCreateEvent::NAME => ['onMonitoringGroupCreateEvent', 20],
        ];
    }

    public function onMonitoringGroupCreateEvent(MonitoringGroupCreateEvent $event)
    {

        $this->logger->info('MonitoringGroup Subscriber says: Event posted this data {id}', [
            'id' => $event->getId(),
        ]);

        $this->entityManager->beginTransaction();

        $monitoringGroup = $this->monitoringGroupRepository->findOneBy(['id' => $event->getId()]);
        $monitoringGroupId = $monitoringGroup->getId();

        $this->entityManager->commit();

    }

}