<?php

declare(strict_types=1);

namespace App\Service\Api;

final class AgentProfiles extends ApiService
{

    private const PARAM_APID = 'apid';
    private const PARAM_OPID = 'optid';
    private const PARAM_APVAL = 'apval';
    private const PARAM_OPTVAL = 'optval'; //string
    private const PARAM_DEVID = 'devid';

    private const URL_API_ASSIGN_AGENT_PROFILE = '/g/apass';
    private const URL_API_GET_AGENT_PROFILE = '/g/apget';
    private const URL_API_SET_AGENT_PROFILE = '/g/apset';
    private const URL_API_DELETE_AGENT_PROFILE = '/g/apdel';

    /**
     * @return false|mixed
     */
    public function createAgentProfile(array $params): mixed
    {

        $urlParams = self::PARAM_APID . '=' . '0';

        foreach($params as $key => $value){

            if($key === 'NAME'){

                $urlParams .= '&'. self::PARAM_OPID .'=' . $key;
                $urlParams .= '&'. self::PARAM_OPTVAL .'=' . $value;

            }else{

                $urlParams .= '&'. self::PARAM_OPID .'=' . $key;
                $urlParams .= '&'. self::PARAM_APVAL .'=' . $value;

            }

        }

        return $this->getApiCall($this->baseUrl . self::URL_API_SET_AGENT_PROFILE . '?' . $urlParams);

    }

    /**
     * @return false|mixed
     */
    public function getAgentProfile(int $profileId): mixed
    {

        return $this->getApiCall($this->baseUrl . self::URL_API_GET_AGENT_PROFILE .
            '?' . self::PARAM_APID . '=' . $profileId);

    }

    /**
     * @param int $agentProfileId
     * @param array $params
     * @return false|mixed
     */
    public function setAgentProfile(int $agentProfileId, array $params): mixed
    {

        $urlParams = self::PARAM_APID . '=' . $agentProfileId;

        foreach($params as $key => $value){

            if($key === 'NAME'){

                $urlParams .= '&'. self::PARAM_OPID .'=' . $key;
                $urlParams .= '&'. self::PARAM_OPTVAL .'=' . $value;

            }else{

                $urlParams .= '&'. self::PARAM_OPID .'=' . $key;
                $urlParams .= '&'. self::PARAM_APVAL .'=' . $value;

            }

        }

        return $this->getApiCall($this->baseUrl . self::URL_API_SET_AGENT_PROFILE . '?' . $urlParams);

    }

    /**
     * @param int $agentProfileId
     * @return false|mixed
     */
    public function deleteAgentProfile(int $agentProfileId): mixed
    {

        return $this->getApiCall($this->baseUrl . self::URL_API_DELETE_AGENT_PROFILE .
            '?' . self::PARAM_APID . '=' . $agentProfileId);

    }

    public function assignDeviceAgentProfile(int $agentProfileId, array $deviceIds): mixed{

        $urlParams = self::PARAM_APID . '=' . $agentProfileId;

        $urlParams .= '&'. self::PARAM_DEVID .'=' . '[' . implode(',',$deviceIds) . ']';

        /*foreach($deviceIds as $deviceId){

            $urlParams .= '&'. self::PARAM_DEVID .'=' . $deviceId;

        }*/

        return $this->getApiCall($this->baseUrl . self::URL_API_ASSIGN_AGENT_PROFILE . '?' . $urlParams);

    }

}