#!/bin/bash

MYODIR="$(pwd)"

cleanup() {
	cd "$MYODIR"
}

trap cleanup EXIT

command -v dirname >/dev/null 2>&1 || {
	echo "\"dirname\" command not available, bailing out."
	exit 1
}

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

if [ -z "$DIR" ] ; then
	echo "Unable to determine runtime directory." >&2
	exit 1
fi

DIR="$DIR/appdir"
cd "$DIR" || {
	echo "Unable to chdir to $DIR" >&2
	exit 1
}

echo
echo "Upgrade must be kicked up from the installed product."
echo "You need to call ${SHORTNAME}_upgrade.sh script from the existing installation."
echo "Trying to look at your deployment(s), wait a while please ..."
. "$DIR/deploy_funcs.sh" || {
	echo "Unable to read deploy functions, exiting..." >&2
	exit 1
}
read_defs || {
	echo "Unable to read basic ${SHORTNAME} definitions, aborting ..." >&2
	exit 1
}
# enumerate deployments
DEPS=$(list_deploys)
[ -z "$DEPS" ] && {
	echo "No $NAME deployment found. Call install.sh script instead of upgrade one (or restore $NAME deployment from backup first if you have one)" >&2
	exit 1
}
DEPS_COUNT=$(echo "$DEPS" | $C_GREP -c "^")
echo "Found $DEPS_COUNT $NAME deployment(s)."
# show all possible upgrade commands
for i in $DEPS ; do
	DOMA=${i#[0-9]*_}
	if [ -d "/opt/$DOMA" ] ; then
		echo "To upgrade domain $DOMA, use command on following line:"
		echo "/opt/$DOMA/${SHORTNAME}_upgrade.sh upgrade $DIR/"
	else
		echo "$NAME deployment $i (domain: $DOMA) was not found, skipping it..." >&2
	fi
done
if [ 1 -eq "$DEPS_COUNT" ] ; then
	if [[ $# -eq 1 && "$1" = "$PARAM_FORCE" ]] ; then
		echo "Force mode detected in one deployment scenario, kicking in upgrade... "
		/bin/bash "/opt/$DOMA/${SHORTNAME}_upgrade.sh" "upgrade" "$DIR/"
		exit $?
	else
		echo "One deployment found. Do you want to autostart the upgrade? (Y for yes)"
		read -r RESP
		[ "Y" = "$RESP" ] && /bin/bash "/opt/$DOMA/${SHORTNAME}_upgrade.sh" "upgrade" "$DIR/"
	fi
fi
if [ "$1" = "$PARAM_FORCE" ] ; then
	echo "More than one deployment detected, unable to run automatically."
	exit 1
else
	exit 0
fi
