<?php

declare(strict_types=1);

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'product_flags')]
#[ORM\Entity]
class ProductFlags
{
    /**
     * @var string
     */
    #[ORM\Column(type: 'string')]
    #[ORM\Id]
    private readonly string $id;

    /**
     * @var int
     */
    #[ORM\Column(type: 'integer', nullable: false)]
    public int $version;

    /**
     * @var string
     */
    #[ORM\Column(name: 'description', type: 'text', nullable: true, options: ['default' => null])]
    public ?string $description = null;

    /**
     * @return string
     */
    public function getId(): string
    {

        return $this->id;

    }

    /**
     * @return int
     */
    public function getVersion(): int{

        return $this->version;

    }

    public function setVersion(int $version){

        $this->version = $version;

    }

    /**
     * @return string
     */
    public function getDescription(): ?string {

        return $this->description;

    }

}