<?php

declare(strict_types=1);

namespace Doctrine\ORM\Mapping;

use Attribute;
use Doctrine\Common\Annotations\Annotation\NamedArgumentConstructor;

/**
 * @Annotation
 * @NamedArgumentConstructor()
 * @Target("PROPERTY")
 */
#[Attribute(Attribute::TARGET_PROPERTY)]
final class ManyToOne implements MappingAttribute
{
    /**
     * @var class-string|null
     * @readonly
     */
    public $targetEntity;

    /**
     * @var string[]|null
     * @readonly
     */
    public $cascade;

    /**
     * The fetching strategy to use for the association.
     *
     * @var string
     * @phpstan-var 'LAZY'|'EAGER'|'EXTRA_LAZY'
     * @readonly
     * @Enum({"LAZY", "EAGER", "EXTRA_LAZY"})
     */
    public $fetch = 'LAZY';

    /**
     * @var string|null
     * @readonly
     */
    public $inversedBy;

    /**
     * @param class-string|null $targetEntity
     * @param string[]|null     $cascade
     * @phpstan-param 'LAZY'|'EAGER'|'EXTRA_LAZY' $fetch
     */
    public function __construct(
        ?string $targetEntity = null,
        ?array $cascade = null,
        string $fetch = 'LAZY',
        ?string $inversedBy = null
    ) {
        $this->targetEntity = $targetEntity;
        $this->cascade      = $cascade;
        $this->fetch        = $fetch;
        $this->inversedBy   = $inversedBy;
    }
}
