<?php

declare(strict_types=1);

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\FormType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class AgentProfileType extends AbstractType {

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {

        $configFormData = $options['data'];

        $builder->add(
            $builder->create('profile', FormType::class, ['inherit_data' => true]),
        );

        $groupBuilder = $builder->get('profile');

        if (!empty($configFormData)) {

            //Name must be the same as in WS
            $groupBuilder->add('NAME', TextType::class, [
                'label' => 'Profile name',
                'data' => ($configFormData['action'] === 'edit') ? $configFormData['name'] : '',
                'required' => true,
                'disabled' => $configFormData['nameEditDisabled'],
            ]);

            foreach ($configFormData['configuration'] as $configFormItem) {

                if ($configFormItem['type'] === 'bool') {
                    $groupBuilder->add($configFormItem['name'], CheckboxType::class, [
                        'label' => $configFormItem['label'] . ' (Actual value: <b>'
                            . (($configFormItem['actualValue'] === '1') ? 'true' : 'false') . '</b>)',
                        'label_html' => true,
                        'help' => $configFormItem['description'] . '.<br>The default value is: <b>'
                            . (($configFormItem['default'] === '0') ? 'false' : 'true')
                            . '</b>' . (($configFormItem['min'] === $configFormItem['max']) ? '.<b> The value cannot be changed!</b>' : '') . '.',
                        'help_html' => true,
                        'required' => false,
                        'data' => (bool)$configFormItem['value'],
                        // 'disabled' => $configFormItem['disabled'],
                    ]);
                } elseif ($configFormItem['type'] === 'int') {
                    // Integer value
                    $attr = [
                        'min' => $configFormItem['min'],
                        'max' => $configFormItem['max'],
                    ];

                    $groupBuilder->add($configFormItem['name'], IntegerType::class, [
                        'label' => $configFormItem['label'] /*. ' (Actual value: <b>'
                            . $configFormItem['actualValue'] . ' ' . $configFormItem['unit'] . '</b>)'*/,
                        'label_html' => true,
                        'help' => $configFormItem['description'] . '<br>The default value is: <b>'
                            . $configFormItem['default']
                            . ((!empty($configFormItem['unit'])) ? ' ' . $configFormItem['unit'] : '')
                            . '</b>. Value must be between: <b>' . $configFormItem['min'] . '</b> and <b>'
                            . $configFormItem['max']
                            . ((!empty($configFormItem['unit'])) ? ' ' . $configFormItem['unit'] : '') . '</b>.',
                        'help_html' => true,
                        'required' => true,
                        // 'disabled' => !$configFormItem['disabled'],
                        'data' => (is_numeric($configFormItem['actualValue'])) ? $configFormItem['actualValue'] : null,
                        'attr' => $attr,

                    ]);
                }
            }
        }

        $builder->add('save', SubmitType::class, ['label' => '<i class="fa-solid fa-floppy-disk" aria-hidden="true"></i> Save', 'label_html' => true]);

    }

    public function configureOptions(OptionsResolver $resolver): void {
        $resolver->setDefaults(
            [
                // 'allow_extra_fields' => true
            ],
        );
    }

}
