<?php

namespace App\Repository;

use App\Entity\DataChangeLog\DataAtom;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method DataAtom|null find($id, $lockMode = null, $lockVersion = null)
 * @method DataAtom|null findOneBy(array $criteria, array $orderBy = null)
 * @method DataAtom[]    findAll()
 * @method DataAtom[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class DataAtomRepository extends ServiceEntityRepository
{

    /**
     * @param ManagerRegistry $registry
     */
    public function __construct(ManagerRegistry $registry){

        parent::__construct($registry, DataAtom::class);

    }

	/**
	 * @param int $id
	 * @param array $values
	 * @return DataAtom|null
	 * @throws \Exception
	 */
    public function update(int $id, array $values): ?DataAtom
    {

        $entityManager = $this->getEntityManager();

		$dataAtom = $this->findOneBy(['id'=> $id]);
		if(!$dataAtom){
			throw new \Exception('DataAtom not found');
		}
		foreach ($values as $key => $value) {
			$dataAtom->$key = $value;
		}

        $entityManager->persist($dataAtom);
        $entityManager->flush();

        return $dataAtom;

    }

}