<?php

declare(strict_types=1);

namespace App\Entity\Product;

use App\Entity\Types\TypesValueType;
use App\ValueObject\Configuration;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'product_conf')]
#[ORM\Entity]
class ProductConf
{

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var Configuration
     *
     */
    #[ORM\Column(type: 'app_config')]
    private string $name;

    /**
     * @var TypesValueType
     */
    #[ORM\ManyToOne(targetEntity: TypesValueType::class, inversedBy: 'productConfigs')]
    #[ORM\JoinColumn(name: 'valtype')]
    public TypesValueType $valType;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    public ?int $intval = null;

    /**
     * @var float|null
     */
    #[ORM\Column(type: Types::FLOAT, nullable: true)]
    public ?float $floatval = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, nullable: true)]
    public ?string $strval = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    public ?int $version = null;

    /**
     * @var \DateTime
     */
    #[ORM\Column(name: 'time', type: Types::DATETIME_MUTABLE, options: ['default' => 'CURRENT_TIMESTAMP'])]
    public \DateTime $time;

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string|null
     */
    public function getName(): ?string {

        return $this->name;

    }

    public function setName(string $name): void{

        $this->name = $name;

    }

    /**
     * @return TypesValueType
     */
    public function getValType(): TypesValueType {

        return $this->valType;

    }

    public function setValType(TypesValueType $valType): void{

        $this->valType = $valType;

    }

    /**
     * @return int
     */
    public function getIntval(): int {

        return $this->intval;

    }

    /**
     * @param int|null $value
     */
    public function setIntval(?int $value): void {

        $this->intval = $value;

    }

    /**
     * @return void
     */
    public function setBoolval(bool $value): void {

        $this->intval = (int) $value;

    }

    /**
     * @return float
     */
    public function getFloatval(): float {

        return $this->floatval;

    }

    /**
     * @param float|null $value
     */
    public function setFloatval(?float $value): void {

        $this->floatval = $value;

    }

    /**
     * @return string
     */
    public function getStrval(): ?string {

        return $this->strval;

    }

    /**
     * @param string|null $value
     */
    public function setStrval(?string $value): void {

        $this->strval = $value;

    }

    /**
     * @return int|null
     */
    public function getVersion(): ?int {

        return $this->version;

    }

    /**
     * @return \DateTime
     */
    public function getTime(): \DateTime {

        return $this->time;

    }

}