<?php

declare(strict_types=1);

namespace App\Service\Api;

use PHPUnit\Util\Exception;
use Symfony\Component\String\Exception\RuntimeException;
use Symfony\Contracts\HttpClient\Exception\ClientExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\RedirectionExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\ServerExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface;

final class FwUpload extends ApiService
{

    private const URL_API_FW_UPLOAD_NOTIFY = '/g/fwnew';

    /**
     * @param int $fwVersionDbId
     * @param string $fwFileName
     * @return string
     * @throws \JsonException
     * @throws ClientExceptionInterface
     * @throws RedirectionExceptionInterface
     * @throws ServerExceptionInterface
     * @throws TransportExceptionInterface
     */
    public function uploadFwNotify(int $fwVersionDbId, string $fwFileName): string
    {

        $urlParams = self::API_PARAM_NVAL . $fwVersionDbId;
        $urlParams .= '&' . self::API_PARAM_TEXT . $fwFileName;

        $result = $this->getApiCall($this->baseUrl . self::URL_API_FW_UPLOAD_NOTIFY . '?' . $urlParams, true);

        if ($result && $result->operation_result->Code === 0) {
            return $result->operation_result->Description;
        }

        throw new RuntimeException($result->operation_result->Description, $result->operation_result->Code);

    }

}
