-- NOTES --
-- DB scheme --
-- add snmp_subdevtype to devices table
ALTER TABLE devices ADD snmp_subdevtype INT DEFAULT NULL;
ALTER TABLE devices ADD FOREIGN KEY (snmp_subdevtype) REFERENCES device_types(id);
-- add signal_csq and signal_rssi
ALTER TABLE device_stats ADD signal_csq SMALLINT DEFAULT NULL;
ALTER TABLE device_stats ADD signal_rssi SMALLINT DEFAULT NULL;
-- update dwarfg version
UPDATE product_versions SET actual = false;
INSERT INTO product_versions (actual, version_major, version_minor, version_patchlevel, version_string, major, beta, notification, force_display, release_date, description) VALUES
(true, 1, 2, 0, 'Afterparty 2 (Keeper BETA 2)', false, true, true, true, '2025-10-02',
'<h5>Release notes</h5>'
'<h6>Server:</h6><ul>'
'<li>Significantly improved DB layer for prepared queries to support cleaning for dynamic connections.</li>'
'<li>Improved SNMP Gateway to support correct translation of SIM card number.</li>'
'<li>Improved detection of Firmware version for Advantech devices over SNMP.</li>'
'<li>Fixed parsing "N/A" for serial number from devices without SN so that it is no longer mistook for "N" for newly registered devices.</li>'
'<li>Added new metrics from devices: signal_csq, signal_rssi. New columns for devices table are available.</li>'
'<li>Improved SNMP Gateway debug options plus commandline override of SSL mode.</li>'
'<li>Updated log grabbing script to include additional system information and vdevices DB view.</li>'
'<li>Added server option FIRMWARE_AUTODOWNLOAD= to allow for completely disabling automatic FW download for offline installations.</li>'
'</ul><h6>Agents:</h6><ul>'
'</ul>');
-- update agent versions -> no upgrade needed, no agent version change between 1.1.0 and 1.2.0
-- UPDATE agent_versions SET actual = false;
-- INSERT INTO agent_versions (dev_type, version_major, version_minor, version_patchlevel, actual) VALUES (1, 1, 1, 0, true), (2, 1, 1, 0, true), (3, 1, 1, 0, true), (4, 1, 1, 0, true);
-- update buildtag
UPDATE product_flags SET description = 'v1.1.0_BETA (+30)' WHERE id = 'buildtag';
UPDATE product_flags SET version = version + 1 WHERE id = 'buildtag';
UPDATE product_flags SET description = 'Dwarfguard - Monitoring, Alerting, Management and Automation System

Build tag: v1.1.0_BETA (+30)
Build date: 2025_10_01__20_15_09

Build components:
(mamas): v1.1.0_BETA (+16)
(mamasbig): v1.1.0_BETA (+2)
(mamasweb): v1.1.0_BETA (+12)
(mamasnotify): v1.1.0_BETA' WHERE id = 'about_info';
UPDATE product_flags SET version = version + 1 WHERE id = 'about_info';
