<?php

namespace App\DataTable\Column;

use Sg\DatatablesBundle\Datatable\Column\Column;

class CustomIpAddressesArrayColumn extends Column
{
    /**
     * {@inheritdoc}
     */
    public function renderSingleField(array &$row): static
    {
        $row[$this->data] = $this->arrayToString($row[$this->data] ?? []);

        return parent::renderSingleField($row);
    }

    /**
     * @param int $tab
     */
    protected function arrayToString( $array, $tab = 0): string
    {
        //dump($array);
        if(empty($array)){
            return '';
        }
        if(!is_array($array)){

            $array = explode(',', $array);
        }

        $arrayField = '';
        $isArrayAssociative = $this->isAssociative($array);
        foreach ($array as $key => $arrayElement) {
            for ($i = 0; $i < $tab; ++$i) {
                $arrayField .= '&nbsp&nbsp';
            }

            if ($isArrayAssociative) {
                $arrayField .= $key.': ';
            }


            //$arrayField .= '<br/>';
            $devNets = explode('¯', $arrayElement);
            $devNetLabel = $devNets[0];
            $devIpAddress = $devNets[1];
            $devIpv6Address = ($devNets[2] === 'NULL') ? null : $devNets[2];

            $arrayField .= '<a href="https://'.$devIpAddress.'">'.$devNetLabel . ': ' .$devIpAddress . '</a>';

            if($devIpv6Address){

                $arrayField .= '<br/>';
                $arrayField .= '<a href="https://['.$devIpv6Address.']">'.$devNetLabel . ': ' .$devIpv6Address . '</a>';
            }

            $arrayField .= '<br/>';

            //$arrayField .= '<span class="badge badge-success" style="margin-right: 3px;">' . $arrayElement.'</span>';
        }

        return $arrayField;
    }

    protected function isAssociative(array $array): bool
    {
        if (empty($array)) {
            return false;
        }

        return array_keys($array) !== range(0, \count($array) - 1);
    }
}
