<?php

declare(strict_types=1);

namespace App\Entity\AgentProfile;

use App\Entity\CustomScript\CustomScriptAgentProfileMap;
use App\Entity\Device\Device;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'agent_profiles')]
#[ORM\Entity]
class AgentProfile
{

    final public const DEFAULT_AGENT_PROFILE_ID = 1;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private readonly int $id;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 64, unique: false, nullable: true)]
    public ?string $profileName = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::SMALLINT, nullable: true, options: ['default' => 10])]
    public ?int $intPing = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::SMALLINT, nullable: true, options: ['default' => 260])]
    public ?int $intRegular = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::SMALLINT, nullable: true, options: ['default' => 10])]
    public ?int $intDebug = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::SMALLINT, nullable: true, options: ['default' => 10])]
    public ?int $intFallback = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::SMALLINT, nullable: true, options: ['default' => 10])]
    public ?int $intFallbackDebug = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::SMALLINT, nullable: true, options: ['default' => 10])]
    public ?int $smallcycles = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::SMALLINT, nullable: true, options: ['default' => 10])]
    public ?int $connfailTolerance = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::SMALLINT, nullable: true, options: ['default' => 10])]
    public ?int $regprogress = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::SMALLINT, nullable: true, options: ['default' => 10])]
    public ?int $fwAutoupgrade = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::SMALLINT, nullable: true, options: ['default' => 10])]
    public ?int $osAutoupgrade = null;

    /**
     * @var bool|null
     */
    #[ORM\Column(type: Types::BOOLEAN, nullable: true, options: ['default' => true])]
    public ?bool $system = null;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'agentProfile', targetEntity: Device::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $devices;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'agentProfile', targetEntity: CustomScriptAgentProfileMap::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $scriptMap;

    /**
     * Label constructor
     */
    public function __construct() {

        $this->devices = new ArrayCollection();
        $this->scriptMap = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getProfileName(): string {

        return $this->profileName;

    }

}