INSERT INTO agents (name, dir_name, package_name, minimal_version, dev_type, show_in_shortcut, description) VALUES
('Advantech routers', 'agent_advantech', 'adwarfg_advantech.tgz', '6.2.0', 2, true, 'Supports V2, V2i, V3 and V4 running ConelOS/ICR OS'),
("Teltonika routers - monitoring+FW flash", 'agent_teltonika', 'adwarfg_teltonika.ipk', NULL, 4, true, 'Monitoring only functionality, server certificate check is disabled.'),
("OpenWRT - only monitoring", 'agent_owrt', 'adwarfg_owrt.ipk', NULL, 3, true, 'Needs installing openssh-client for tunnels on the OpenWRT system, otherwise monitoring-only. Server certificate check is disabled.'),
('GNU/Linux (generic)', 'agent_linux', 'adwarfg_linux.tgz', NULL, 1, true, 'Generic Linux agent with systemd/initd integration. Cmdline installation.'),
("Teltonika routers - cmdline, monitoring+FW flash", 'agent_teltonika', 'adwarfg_teltonika.tgz', NULL, 4, false, 'Cmdline install. Needs installing openssh-client for tunnels on the Teltonika system. Server certificate check is disabled.'),
("OpenWRT - cmdline, mon. only", 'agent_owrt', 'adwarfg_owrt.tgz', NULL, 3, false, 'Cmdline install. Needs installing openssh-client for tunnels on the OpenWRT system. Server certificate check is disabled.'),
("AAD - automated agent deployment tool", 'aad', 'push_agent.py', NULL, 1, false, 'A command-line level Python tool to automate mass device installation. See documentation before experimenting.');

INSERT INTO agent_device_type_map (agent_id, device_type_id) VALUES (1, 2), (2, 1), (3, 3), (4, 4), (1, 5);

INSERT INTO agent_versions (dev_type, version_major, version_minor, version_patchlevel, actual) VALUES
(1, 1, 1, 0, true),
(2, 1, 1, 0, true),
(3, 1, 1, 0, true),
(4, 1, 1, 0, true);

INSERT INTO product_versions (id, actual, version_major, version_minor, version_patchlevel, version_string, major, beta, notification, force_display, release_date, description) values 
(1, true, 1, 3, 0, 'Afterparty 3 (Keeper BETA 3)', false, true, true, true, '2025-10-20',
'<h5>Release notes</h5>'
'<b>The release notes below are not completely relevant to the BETA version you are running, these are preparations for the Dwarfguard 2.0.0 Keeper version.</b>'
'<h6>Server:</h6><ul>'
'<li>Support for manual upload of firmware files by user + logging for this action.</li>'
'<li>Support firmware management for Teltonika devices (running RUTOS).</li>'
'<li>Initial support for CSTECH devices (includes firmware management for CSTECH Linux).</li>'
'<li>Introduced SNMP Gateway to allow monitoring of SNMP devices (aimed at Advantech v1 routers but concept works for any SNMP device).</li>'
'<li>Implemented SSH tunnels via web gateway and proxy.</li>'
'<li>Support model name (device model) and added it as optional column on the Devices table allowing filtering+sorting based on that.</li>'
'<li>Added dwarfg_user command allowing server admin to add new UI users.</li>'
'<li>Added SignalQuality as an optional column for the Devices table.</li>'
'<li>Added Note1,2,3 fields to the Device details.</li>'
'<li>Implemented CSV download from Devices table.</li>'
'<li>Corrected daily/monthly traffic counting to be able to handle big numbers.</li>'
'<li>Webtunnels (and SSH tunnels) now run on subdomain instead of sub-url.</li>'
'<li>Added SSHWifty tool being used as web SSH gateway (replaced WebSSH).</li>'
'<li>Added Reboot button into Devices table actions to schedule a reboot for a particular device.</li>'
'<li>List of triggered devices can now be accessed directly from alert definition table.</li>'
'<li>Improvements in UI - horizontal scrolling, ordering fix</li>'
'<li>If self-signed certificate is created (distributed to devices) it now contains CA certificate as well.</li>'
'<li>Updated Symfony.</li>'
'<li>Incorporated all fixes from stable support releases 1.0.1 - 1.0.4</li>'
'<li></li>'
'</ul><h6>Agents:</h6><ul>'
'<li>Support for CSTECH devices (enhanced Advatech agent to cover both Advantech and CSTECH devices)</li>'
'<li>Support firmware flash process on Teltonika devices (RUTOS).</li>'
'<li>Support firmware flash process on CSTECH devices (CSTECH Linux).</li>'
'<li>Teltonika: Dwarfguard agent installation survives firmware flash now (but is no longer registered as installed package by the opkg manager).</li>'
'<li>Teltonika: Startup protection - when FW flash disables Dwarfguard agent startup, backup mechanism enables it again.</li>'
'<li>Support sending device model name to server when detected.</li>'
'<li>FW flash process (in general) made more rebust.</li>'
'<li></li>'
'</ul>');

INSERT INTO product_flags(id, version, description) values ('buildtag', 1, 'v1.2.0_BETA (+6)');
INSERT INTO product_flags(id, version, description) values ('about_info', 1, 'Dwarfguard - Monitoring, Alerting, Management and Automation System

Build tag: v1.2.0_BETA (+6)
Build date: 2025_10_07__17_18_00

Build components:
(mamas): v1.2.0_BETA (+5)
(mamasbig): v1.2.0_BETA (+1)
(mamasweb): v1.2.0_BETA
(mamasnotify): v1.2.0_BETA');
