<?php

declare(strict_types=1);

namespace App\Entity\Alert;

use App\Entity\TypesValueType;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'alert_target_spec')]
#[ORM\Entity]
class AlertTargetSpec implements \Stringable
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 64, nullable: false, unique: true)]
    public string $name;

    /**
     * @var TypesValueType
     */
    #[ORM\ManyToOne(targetEntity: \App\Entity\TypesValueType::class, inversedBy: 'alertTargetSpecs')]
    #[ORM\JoinColumn(name: 'valtype')]
    public TypesValueType $valType;

    /**
     * @var AlertTableSelection
     */
    #[ORM\ManyToOne(targetEntity: \App\Entity\Alert\AlertTableSelection::class, inversedBy: 'alertTargetSpec')]
    #[ORM\JoinColumn(name: 'seltype')]
    public AlertTableSelection $selType;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(targetEntity: \App\Entity\Alert\AlertTargetMap::class, mappedBy: 'targetSpec', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $targetMaps;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(targetEntity: \App\Entity\Alert\Alert::class, mappedBy: 'targetSpec', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'target_spec')]
    public Collection $alerts;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 64, nullable: false, unique: true)]
    public string $hint;

    /**
     * AlertTargetSpec constructor
     */
    public function __construct() {

        $this->targetMaps = new ArrayCollection();
        $this->alerts = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getName(): string {

        return $this->name;

    }

    /**
     * @return TypesValueType
     */
    public function getValType(): TypesValueType {

        return $this->valType;

    }

    /**
     * @return AlertTableSelection
     */
    public function getSelType(): AlertTableSelection {

        return $this->selType;

    }

    /**
     * @return string
     */
    public function getHint(): string {

        return $this->hint;

    }

    /**
     * @return string
     */
    public function __toString(): string {

        return $this->name;

    }

}