<?php

declare(strict_types=1);

namespace App\Entity\Tool;

use App\Entity\Device;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'auth_profiles')]
#[ORM\Entity]
class AuthProfile
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: true)]
    public ?string $profileName = null;

    /**
     * @var string
     */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: false)]
    public string $username;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: true)]
    public ?string $sshPwd = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::INTEGER, length: 11, nullable: true)]
    public ?int $pwdSalt = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::INTEGER, length: 11, nullable: true)]
    public ?int $pwdPepper = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::INTEGER, length: 11, nullable: true)]
    public ?int $pwdChilli = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::INTEGER, length: 11, nullable: true)]
    public ?int $pwdVersion = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::TEXT, nullable: true)]
    public ?string $sshKey = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::INTEGER, length: 11, nullable: true)]
    public ?int $keySalt = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::INTEGER, length: 11, nullable: true)]
    public ?int $keyPepper = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::INTEGER, length: 11, nullable: true)]
    public ?int $keyChilli = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::INTEGER, length: 11, nullable: true)]
    public ?int $keyVersion = null;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'authProfile', targetEntity: Device::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $devices;

    public function __construct() {

        $this->devices = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string|null
     */
    public function getProfileName(): ?string
    {
        return $this->profileName;
    }

    /**
     * @param string|null $profileName
     */
    public function setProfileName(?string $profileName): void
    {
        $this->profileName = $profileName;
    }

    /**
     * @return string
     */
    public function getUsername(): string
    {
        return $this->username;
    }

    /**
     * @param string $username
     */
    public function setUsername(string $username): void
    {
        $this->username = $username;
    }

    /**
     * @return string|null
     */
    public function getSshPwd(): ?string
    {
        return $this->sshPwd;
    }

    /**
     * @param string|null $sshPwd
     */
    public function setSshPwd(?string $sshPwd): void
    {
        $this->sshPwd = $sshPwd;
    }

    /**
     * @return string|null
     */
    public function getPwdSalt(): ?int
    {
        return $this->pwdSalt;
    }

    /**
     * @param string|null $pwdSalt
     */
    public function setPwdSalt(?int $pwdSalt): void
    {
        $this->pwdSalt = $pwdSalt;
    }

    /**
     * @return string|null
     */
    public function getPwdPepper(): ?int
    {
        return $this->pwdPepper;
    }

    /**
     * @param string|null $pwdPepper
     */
    public function setPwdPepper(?int $pwdPepper): void
    {
        $this->pwdPepper = $pwdPepper;
    }

    /**
     * @return string|null
     */
    public function getPwdChilli(): ?int
    {
        return $this->pwdChilli;
    }

    /**
     * @param string|null $pwdChilli
     */
    public function setPwdChilli(?int $pwdChilli): void
    {
        $this->pwdChilli = $pwdChilli;
    }

    /**
     * @return string|null
     */
    public function getPwdVersion(): ?int
    {
        return $this->pwdVersion;
    }

    /**
     * @param string|null $pwdVersion
     */
    public function setPwdVersion(?int $pwdVersion): void
    {
        $this->pwdVersion = $pwdVersion;
    }

    /**
     * @return string|null
     */
    public function getSshKey(): ?string
    {
        return $this->sshKey;
    }

    /**
     * @param string|null $sshKey
     */
    public function setSshKey(?string $sshKey): void
    {
        $this->sshKey = $sshKey;
    }

    /**
     * @return string|null
     */
    public function getKeySalt(): ?int
    {
        return $this->keySalt;
    }

    /**
     * @param string|null $keySalt
     */
    public function setKeySalt(?int $keySalt): void
    {
        $this->keySalt = $keySalt;
    }

    /**
     * @return string|null
     */
    public function getKeyPepper(): ?int
    {
        return $this->keyPepper;
    }

    /**
     * @param string|null $keyPepper
     */
    public function setKeyPepper(?int $keyPepper): void
    {
        $this->keyPepper = $keyPepper;
    }

    /**
     * @return string|null
     */
    public function getKeyChilli(): ?int
    {
        return $this->keyChilli;
    }

    /**
     * @param string|null $keyChilli
     */
    public function setKeyChilli(?int $keyChilli): void
    {
        $this->keyChilli = $keyChilli;
    }

    /**
     * @return string|null
     */
    public function getKeyVersion(): ?int
    {
        return $this->keyVersion;
    }

    /**
     * @param string|null $keyVersion
     */
    public function setKeyVersion(?int $keyVersion): void
    {
        $this->keyVersion = $keyVersion;
    }

}