<?php

namespace App\Datatables;

use App\Bundles\Sg\DatatablesBundle\Datatable\Filter\CustomSelectFilter;
use App\Datatables\Column\CustomArrayColumn;
use App\Entity\CustomScript\CustomScript;
use Sg\DatatablesBundle\Datatable\Column\ActionColumn;
use Sg\DatatablesBundle\Datatable\Column\DateTimeColumn;
use Sg\DatatablesBundle\Datatable\Editable\TextEditable;
use Sg\DatatablesBundle\Datatable\Filter\DateRangeFilter;
use Sg\DatatablesBundle\Datatable\Filter\TextFilter;
use Sg\DatatablesBundle\Datatable\Column\Column;

/**
 * Class CustomScriptDatatable
 * @package App\Datatables
 */
class CustomScriptDatatable extends BaseDatatable
{

    protected string $entity = CustomScript::class;
    protected string $name = 'custom_scripts_datatable';

    /**
     * @param array $options
     * @throws \Exception
     */
    public function buildDatatable(array $options = array()): void
    {

        parent::buildDatatable($options);

        $deviceTypes = $options['deviceTypes'];
        $agentProfiles = $options['agentProfiles'];

        $this->extensions->set(array(
            'buttons' => array(
                'create_buttons' => array(  // custom buttons
                    array(
                        'action' => array(
                            'template' => '/datatable/customScript/createCustomScript.js.twig',
                            'vars' => array('link' =>  $this->router->generate('admin_custom_script_add')),
                        ),
                        'class_name' => 'btn-add',
                        'name' => 'addCustomScript',
                        'text' => '<i class=\"fa fa-plus\"></i> Add Custom Script',
                    ),
                    $this->getRefreshButton()
                ),
            )
        ));

        $this->addIdColumn();

        $this->columnBuilder
            ->add('description', Column::class, array(
                'title' => 'Description',
                'width' => '40%;',
                'filter' => array(TextFilter::class,
                    array(
                        'cancel_button' => true,
                    ),
                ),
                'editable' => array(TextEditable::class,
                    array(
                        'url' => 'app_datatables_edit',
                        'placeholder' => 'Edit value',
                        'empty_text' => 'None',
                        'editable_if' => function ($row) {
                            if ($this->getUser()) {
                                /*if(true === $this->isAdmin()) {*/
                                    return true;
                                /*};*/
                            }

                            return true;
                        },
                        'mode' => 'inline',
                    ),
                ),
            ))
            ->add(
                'deviceType',
                CustomArrayColumn::class,
                [
                    'name' => 'deviceTypes',
                    'title' => 'Device Types',
                    'width' => '100%;',
                    'dql' => "(SELECT GROUP_CONCAT({dt}.name) FROM App:CustomScript\CustomScriptDevTypeMap {csdvm}
                                JOIN App:DeviceType {dt} with {dt}.id = {csdvm}.devType
                                WHERE {csdvm}.script = customscript.id)",
                    'type_of_field' => 'integer',
                    'searchable' => true,
                    'orderable' => true,
                    'filter' => [
                        CustomSelectFilter::class,[
                            'classes' => '',
                            'search_type' => 'nothing',
                            'multiple' => false,
                            'select_options' => ['' => 'Any'] +
                                $this->getOptionsArrayFromEntities($deviceTypes, 'id', 'name'),
                            'cancel_button' => true,
                        ],
                    ],
                ]
            )
            ->add(
                'agentProfile',
                CustomArrayColumn::class,
                [
                    'name' => 'agentProfiles',
                    'title' => 'Agent Profiles',
                    'width' => '100%;',
                    'dql' => "(SELECT GROUP_CONCAT({ap}.profileName) FROM App:CustomScript\CustomScriptAgentProfileMap {csapm}
                                JOIN App:AgentProfile\AgentProfile {ap} with {ap}.id = {csapm}.agentProfile
                                WHERE {csapm}.script = customscript.id)",
                    'type_of_field' => 'integer',
                    'searchable' => true,
                    'orderable' => true,
                    'filter' => [
                        CustomSelectFilter::class,[
                            'classes' => '',
                            'search_type' => 'nothing',
                            'multiple' => false,
                            'select_options' => ['' => 'Any'] +
                                $this->getOptionsArrayFromEntities($agentProfiles, 'id', 'profileName'),
                            'cancel_button' => true,
                            ],
                        ],
                    ]
            )
           /* ->add('version', Column::class, array(
                'title' => 'Version',
                'width' => '100%;',
                'default_content' => 'Not Assigned',
                'filter' => array(TextFilter::class,
                    array(
                        'cancel_button' => true,
                    ),
                ),
            ))*/
            ->add('lastUpdate', DateTimeColumn::class, array(
                'title' => 'Updated',
                'searchable' => true,
                'filter' => array(DateRangeFilter::class, array(
                    'cancel_button' => true,
                )),
                'date_format' => self::DATETIME_FORMAT,
            ))
            ->add(null, ActionColumn::class, array(
                'title' => $this->translator->trans('sg.datatables.actions.title'),
                'width' => '100%;',
                'actions' => array(
                    array(
                        'route' => 'admin_custom_script_edit',
                        'route_parameters' => array(
                            'customScriptId' => 'id',
                            ),
                        'label' => $this->translator->trans('sg.datatables.actions.edit'),
                        'icon' => self::ICON_DETAIL,
                        'attributes' => array(
                            'rel' => 'tooltip',
                            'title' => $this->translator->trans('sg.datatables.actions.edit'),
                            'class' => 'btn btn-primary btn-xs mb-1 mr-sm-2',
                            'role' => 'button',
                        ),
                        'start_html' => '<div class="input-group">',
                        'render_if' => function ($row) {
                            return  $this->authorizationChecker->isGranted('ROLE_ADMIN');
                        },

                    ),
                    array(
                        'route' => 'ajax_custom_script_delete',
                        'route_parameters' => array(
                            'customScriptId' => 'id',
                            ),
                        'label' => $this->translator->trans('sg.datatables.actions.delete'),
                        'icon' => self::ICON_DELETE,
                        'attributes' => array(
                            'rel' => 'tooltip',
                            'title' => $this->translator->trans('sg.datatables.actions.delete'),
                            'class' => 'btn btn-danger btn-xs mb-1',
                            'role' => 'button',
                            'data-toggle' => 'modal',
                            'id' => 'delete',
                            'data-target' => "#confirm-delete",
                        ),
                        'render_if' => function ($row) {
                            return $this->authorizationChecker->isGranted('ROLE_ADMIN');
                        },
                        'end_html' => '</div>',

                    ),

                    ),
                ))

        ;
    }

}