<?php

declare(strict_types=1);

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'data_atom')]
#[ORM\Entity]
class DataAtom
{

    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 64, nullable: false, unique: true)]
    public string $name;

    /**
     * @var boolean
     */
    #[ORM\Column(type: 'boolean', nullable: false)]
    public bool $visible;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(targetEntity: \App\Entity\DataChangeLog::class, mappedBy: 'atom', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $atoms;

    /**
     * EventSource constructor
     */
    public function __construct(){

        $this->atoms = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getName(): string {

        return $this->name;

    }

    /**
     * @return bool
     */
    public function isVisible(): bool
    {
        return $this->visible;
    }

}