#!/bin/bash
SCRIPT="loglevels.cgi"
SCRIPT_SET="set.cgi"
SRC="/opt/adwarfg/www/cgi_common.sh"

. $SRC

load_settings
g_serverurl=${g_serverurl:-$DEF_SERVER}
echo "Content-type: text/html"
echo "Cache-Control: no-cache"
echo "Pragma: no-cache"
echo ""
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">"
echo "<html>"
echo "<head>"
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">"
echo "<meta http-equiv=\"Content-Style-Type\" content=\"text/css\">"
echo "<meta http-equiv=\"Content-Script-Type\" content=\"text/javascript\">"
echo "<title>Dwarfguard Agent</title>"
echo "<style type=\"text/css\">"
echo "<!--"
echo "body, table, tr, td, a {"
  echo "font-size: 12px; font-family: Verdana, Arial, Helvetica, sans-serif;"
echo "}"
echo "input, select, option, textarea, button {"
  echo "font-size: 13.3333px;"
echo "}"
echo "form, input {"
  echo "margin: 0px;"
echo "}"
echo "pre {"
  echo "margin: 10px 0px 10px 0px;"
echo "}"
echo "h2 {"
  echo "font-size: 24px; margin-bottom: 3px;"
echo "}"
echo "a {"
  echo "color: #004280; text-decoration: none;"
echo "}"
echo "a:hover {"
  echo "text-decoration: underline;"
echo "}"
echo ".logo {"
  echo "color: #004280; text-shadow: #B0C0E0 2px 2px 2px; filter: shadow(color=#B0C0E0, direction=145, strength=4);"
echo "}"
echo ".window {"
  echo "background-color: #F4F4F4; border: 2px solid #004280; border-collapse: collapse;"
echo "}"
echo ".title {"
  echo "color: #FFFFFF; background-color: #004280; font-weight: bold;"
echo "}"
echo ".header {"
  echo "color: #000000; background-color: #C0E0FF;"
echo "}"
echo ".input {"
  echo "width: 165px;"
echo "}"
echo ".settings td {"
  echo "padding-bottom: 10px;"
echo "}"
echo "-->"
echo "</style>"
echo "</head>"
echo "<body bgcolor=\"#FFFFFF\">"
echo "<table width=\"100%\" cellspacing=\"2\" cellpadding=\"2\" border=\"0\">"
  echo "<tr>"
    echo "<td nowrap class=\"logo\"><h2>Dwarfguard Agent</h2></td>"
  echo "</tr>"
echo "</table>"
echo "<table width=\"100%\" cellspacing=\"2\" cellpadding=\"2\" border=\"0\">"
  echo "<tr>"
    echo "<td valign=\"top\" width=\"1%\">"
      echo "<table width=\"200\" cellspacing=\"0\" cellpadding=\"5\" border=\"2\" class=\"window\">"
      echo "<tr>"
          echo "<td nowrap class=\"title\">Status</td>"
        echo "</tr>"
        echo "<tr>"
          echo "<td>"
            echo "<table cellspacing=\"2\" cellpadding=\"1\">"
              echo "<tr><td nowrap><a href=\"index.cgi\">General Info</a></td></tr>"
            echo "</table>"
          echo "</td>"
        echo "</tr>"
        echo "<tr>"
           echo "<td>"
            echo "<table cellspacing=\"2\" cellpadding=\"1\">"
              echo "<tr><td nowrap><a href=\"systemlogs.cgi\">System Logs</a></td></tr>"
            echo "</table>"
          echo "</td>"
        echo "</tr>"
        echo "<tr>"
          echo "<td nowrap class=\"title\">Configuration</td>"
        echo "</tr>"
        echo "<tr>"
          echo "<td>"
            echo "<table cellspacing=\"2\" cellpadding=\"1\">"
              echo "<tr><td nowrap><a href=\"settings.cgi\">Global</a></td></tr>"
            echo "</table>"
          echo "</td>"
          echo "</tr>"
          echo "<tr>"
           echo "<td>"
            echo "<table cellspacing=\"2\" cellpadding=\"1\">"
              echo "<tr><td nowrap><a href=\"loglevels.cgi\">Log Levels</a></td></tr>"
            echo "</table>"
          echo "</td>"
        echo "</tr>"
        echo "<tr>"
          echo "<td nowrap class=\"title\">General</td>"
        echo "</tr>"
        echo "<tr>"
          echo "<td>"
            echo "<table cellspacing=\"2\" cellpadding=\"1\">"
              echo "<tr><td nowrap><a href=\"../../module.cgi\">Return</a></td></tr>"
            echo "</table>"
          echo "</td>"
        echo "</tr>"
      echo "</table>"
    echo "</td>"
    echo "<td valign=\"top\" width=\"99%\">"
      echo "<form method=POST action=\"${SCRIPT_SET}\">"
      echo "<table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" border=\"2\" class=\"window\">"
        echo "<tr>"
          echo "<td align=\"center\" class=\"title\">Dwarfguard Log Levels configuration</td>"
        echo "</tr>"
          echo "<tr>"
          echo "<td>"
          echo "<table class=\"settings\" style=\"word-break:break-all; word-wrap:normal; \">"
          echo "  <tbody><tr>"
          echo "  <td align=\"left\">Current debuglevel:"
          echo "  </td><td align=\"left\"> <b>$g_alevel_debug</>"
          echo "  </td><td align=\"left\"><span class=\"help-block\"></span>"
          echo "  </td></tr>"
          echo "<tr>"
          echo " <td align=\"left\">Current loglevel:"
          echo "  </td><td align=\"left\"> <b>$g_alevel_log</>"
          echo "  </td><td align=\"left\"><span class=\"help-block\"></span>"
          echo "  </td>"
          echo "</tr>"
          echo "</tbody></table>"
         

          if [ $g_alevel_debug -lt 3 ] || [ $g_alevel_log -lt 4 ] ; then
            echo "<p><b style=\"color:red\">WARNING: agent is set to store extra logging messages. This increases log size.</b></p>"
          fi

          echo "<table style=\"word-break:break-all; word-wrap:normal; \">"
          echo "<tbody><tr>"
          echo "<td align=\"left\"><label class=\"control-label\" for=\"loglevel_preset\">Choose one of the presets:</label>"
          echo "</td><td align=\"left\"><select class=\"form-control\" name=\"loglevel_preset\" id=\"loglevel_preset\" data-role=\"slider\">"
          echo "<option value=\"LogNone\" selected=\"\">Log errors (default)</option>"
          echo "<option value=\"LogInfo\">Log basic messages</option>"
          echo "<option value=\"LogVerbose\">Verbose log</option>"
          echo "<option value=\"LogAll\">Debug logs</option>"
          echo "</select>"
          echo "</td><td align=\"left\"><span class=\"help-block\">The default is to log only errors.</span>"
          echo " </td></tr>"
           echo "<tr>"
          echo " <td align=\"left\"><button class=\"ui-btn ui-btn-inline\" style=\"margin-top:15px\" type=\"submit\" name=\"submit\" id=\"submit\">Set Log Level</button>"
          echo "  </td>"
          echo "</tr>"
          echo "</tbody></table>"
      echo "</form>"
    echo "</td>"
  echo "</tr>"
echo "</table>"
echo "</body>"
echo "</html>"

exit 0
