<?php

declare(strict_types=1);

namespace App\Entity\Alert;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'alert_target_map')]
#[ORM\Entity]
class AlertTargetMap
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var AlertTargetSpec
     */
    #[ORM\ManyToOne(targetEntity: AlertTargetSpec::class, inversedBy: 'targetMaps')]
    #[ORM\JoinColumn(name: 'target_spec', referencedColumnName: 'id')]
    public AlertTargetSpec $targetSpec;

    /**
     * @var AlertTargetType
     */
    #[ORM\ManyToOne(targetEntity: AlertTargetType::class, inversedBy: 'targetMaps')]
    #[ORM\JoinColumn(name: 'target_type', referencedColumnName: 'id')]
    public AlertTargetType $targetType;

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return AlertTargetSpec
     */
    public function getTargetSpec(): AlertTargetSpec {

        return $this->targetSpec;

    }

    /**
     * @return AlertTargetType
     */
    public function getTargetType(): AlertTargetType {

        return $this->targetType;

    }

}