<?php

declare(strict_types=1);

namespace App\Entity\Device;

use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'agents')]
#[ORM\Entity]
class DeviceAgent
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: Types::STRING, length: 32, nullable: false)]
    public string $name;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 256, nullable: true)]
    public ?string $description = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 32, nullable: true)]
    public ?string $minimalVersion = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 32, nullable: true)]
    public ?string $dirName = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: true)]
    public ?string $packageName = null;

    /**
     * @var bool|null
     */
    #[ORM\Column(type: Types::BOOLEAN, length: 1, nullable: true)]
    public ?bool $showInShortcut = null;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'deviceAgent', targetEntity: DeviceTypeAgentMapping::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $deviceTypeAgentMappings;

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getName(): string {

        return $this->name;

    }

    /**
     * @return string|null
     */
    public function getDescription(): ?string {

        return $this->description;

    }

    /**
     * @return string|null
     */
    public function getMinimalVersion(): ?string {

        return $this->minimalVersion;

    }

    /**
     * @return string|null
     */
    public function getDirName(): ?string {

        return $this->dirName;

    }

    /**
     * @return string|null
     */
    public function getPackageName(): ?string {

        return $this->packageName;

    }

}