<?php

namespace App\Command;

use App\Service\MessageService;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(
    name: 'app:send-notification',
    description: 'Send Dwarfguard notification.',
)]
class SendNotificationCommand extends Command
{

    protected MessageService $messageService;

    /**
     * SendSlackNotificationCommand constructor.
     * @param MessageService $messageService
     */
    public function __construct(MessageService $messageService){

        parent::__construct();
        $this->messageService = $messageService;

    }

    /**
     * Configure
     */
    protected function configure(): void
    {

        // the full command description shown when running the command with
        // the "--help" option
        $this->setHelp('This command allows you to send Mamas notifications.');

        $this->addArgument('message', InputArgument::REQUIRED, 'The message for the user.');

    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int
     * @throws \Symfony\Component\Notifier\Exception\TransportExceptionInterface
     */
    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        // outputs multiple lines to the console (adding "\n" at the end of each line)
        $output->writeln([
            'Mamas notification',
            '==================',
            '',
        ]);

        $message = $input->getArgument('message');

        list($resultSlack, $resultEmail) = $this->messageService->sendMessage($message);

        if ($resultSlack && $resultEmail) {

            $output->writeln('Message successfully sent.');
            return Command::SUCCESS;

        }elseif ($resultSlack && $resultEmail === null){

            $output->writeln('Message successfully sent.');
            return Command::SUCCESS;

        }elseif(!$resultSlack){

            $output->writeln('Message to Slack sent error.');
            return Command::FAILURE;

        }elseif ($resultEmail === false){

            $output->writeln('Message to Email sent error.');
            return Command::FAILURE;

        }

        $output->writeln('Message sent error.');

        // or return this if some error happened during the execution
        // (it's equivalent to returning int(1))
        return Command::FAILURE;
    }
    
}