<?php

declare(strict_types=1);

namespace App\Entity\Device;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'device_notes')]
#[ORM\Entity]
class DeviceNote {

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $idDevice = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: true)]
    public ?string $note1 = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: true)]
    public ?string $note2 = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: true)]
    public ?string $note3 = null;

    /**
     * @var Device
     */
    #[ORM\OneToOne(inversedBy: 'noteDevice', targetEntity: Device::class)]
    #[ORM\JoinColumn(name: 'id_device', referencedColumnName: 'id_device', nullable: true)]
    public Device $device;

    /**
     * @return int|null
     */
    public function getId(): ?int {
        return $this->id;
    }

}
