<?php

declare(strict_types=1);

namespace App\Entity\Device;

use App\Entity\Device;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'user_modules')]
#[ORM\Entity]
class UserModule implements \Stringable
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(name: 'name', type: Types::STRING, length: 128, nullable: false)]
    public string $name;

    /**
     * @var string
     */
    #[ORM\Column(name: 'versionstring', type: Types::STRING, length: 64, nullable: true)]
    public string $version;

    /**
     * @var bool
     */
    #[ORM\Column(type: Types::BOOLEAN, options: ['default' => 0])]
    public bool $internal = false;

    /**
     * @var bool
     */
    #[ORM\Column(type: Types::BOOLEAN, options: ['default' => 0])]
    public bool $available = false;

    /**
     * @var bool
     */
    #[ORM\Column(type: Types::BOOLEAN, options: ['default' => 0])]
    public bool $approved = false;

    /**
     * @var bool
     */
    #[ORM\Column(type: Types::BOOLEAN, options: ['default' => 0])]
    public bool $hidden = false;

	/**
	 * @var Collection
	 */
	#[ORM\OneToMany(mappedBy: 'userModule', targetEntity: Device\DeviceUserModule::class, cascade: ['persist'])]
	#[ORM\JoinColumn(name: 'id')]
	public Collection $userModules;


	public function __construct() {

		$this->userModules = new ArrayCollection();

	}

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getVersion(): string {

        return $this->version;

    }

    /**
     * @return bool
     */
    public function isHidden(): bool
    {
        return $this->hidden;
    }

    /**
     * @return bool
     */
    public function isInternal(): bool
    {
        return $this->internal;
    }

    /**
     * @return bool
     */
    public function isAvailable(): bool
    {
        return $this->available;
    }

    /**
     * @return bool
     */
    public function isApproved(): bool
    {
        return $this->approved;
    }

    /**
     * @return string
     */
    public function __toString(): string {

        return $this->getVersion();

    }

}