<?php

declare(strict_types=1);

namespace App\Service\Api;

final class ConfigProfiles extends ApiService
{

    private const PARAM_NVAL = 'nval';
    private const PARAM_DEVID = 'devid';

    private const URL_API_GET_CONFIG_PROFILE = '/g/cpget';
    private const URL_API_UPDATE_CONFIG_PROFILE = '/g/cpupd';
    private const URL_API_SET_CONFIG_PROFILE = '/g/cpset';

	/**
	 * @param int $deviceId
	 * @return mixed
	 * @throws \JsonException
	 * @throws \Symfony\Contracts\HttpClient\Exception\ClientExceptionInterface
	 * @throws \Symfony\Contracts\HttpClient\Exception\RedirectionExceptionInterface
	 * @throws \Symfony\Contracts\HttpClient\Exception\ServerExceptionInterface
	 * @throws \Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface
	 */
    public function createConfigProfileByDeviceId(int $deviceId): mixed
    {

        $urlParams = self::PARAM_NVAL . '=' . '0&' . self::PARAM_DEVID . '=' . $deviceId;

		$jsonData = '{"Profile":[]}';

        return $this->postApiCall($this->baseUrl . self::URL_API_UPDATE_CONFIG_PROFILE . '?' .
			$urlParams, $jsonData, true, false);

    }

	public function createConfigProfileByProfileId(int $profileId): mixed
	{

		$urlParams = self::PARAM_NVAL . '=' . '0&' . self::PARAM_DEVID . '=' . $profileId;

		return $this->postApiCall($this->baseUrl . self::URL_API_UPDATE_CONFIG_PROFILE . '?' .
			$urlParams, null, true);

	}

	/**
	 * @param int $configProfileId
	 * @param array $deviceIds
	 * @return mixed
	 * @throws \JsonException
	 * @throws \Symfony\Contracts\HttpClient\Exception\ClientExceptionInterface
	 * @throws \Symfony\Contracts\HttpClient\Exception\RedirectionExceptionInterface
	 * @throws \Symfony\Contracts\HttpClient\Exception\ServerExceptionInterface
	 * @throws \Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface
	 */
    public function assignDeviceToConfigProfile(int $configProfileId, array $deviceIds): mixed{

        $urlParams = self::PARAM_NVAL . '=' . $configProfileId;
        $urlParams .= '&'. self::PARAM_DEVID .'=' . '[' . implode(',',$deviceIds) . ']';

        return $this->getApiCall($this->baseUrl . self::URL_API_SET_CONFIG_PROFILE . '?' . $urlParams, true);

    }

	/**
	 * @param array $deviceIds
	 * @return mixed
	 * @throws \JsonException
	 * @throws \Symfony\Contracts\HttpClient\Exception\ClientExceptionInterface
	 * @throws \Symfony\Contracts\HttpClient\Exception\RedirectionExceptionInterface
	 * @throws \Symfony\Contracts\HttpClient\Exception\ServerExceptionInterface
	 * @throws \Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface
	 */
	public function UnassignDeviceFromConfigProfile( array $deviceIds): mixed
	{

		$urlParams = self::PARAM_NVAL . '=0';
		$urlParams .= '&'. self::PARAM_DEVID .'=' . '[' . implode(',',$deviceIds) . ']';

		return $this->getApiCall($this->baseUrl . self::URL_API_SET_CONFIG_PROFILE . '?' . $urlParams, true);


	}

	public function downloadConfigProfile(int $profileId): mixed
	{

		$urlParams = self::PARAM_NVAL . '=' . $profileId;

		return $this->getApiCall($this->baseUrl . self::URL_API_GET_CONFIG_PROFILE . '?' .
			$urlParams, true);

	}

	public function updateConfigProfile(int $profileId, string $jsonData): mixed
	{

		$urlParams = self::PARAM_NVAL . '=' . $profileId;

		return $this->postApiCall($this->baseUrl . self::URL_API_UPDATE_CONFIG_PROFILE . '?' .
		$urlParams, $jsonData, false, false);

	}

}