#!/bin/bash

BASEDEFS="base_defs"

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

. "$DIR"/"$BASEDEFS" || { echo "Fatal: Definition file ($BASEDEFS) not found."; exit 1; }
. "$DIR"/"$BASEFUNCS" || { echo "Fatal: Basic functions ($BASEFUNCS) not found."; exit 1; }

MYTMPDIR="/tmp/${SHORTNAME}_cust_agent.$$/"
ACTDIR="tmp"
MYOLDDIR=$(pwd)

tidy_up() {
	cd "$MYOLDDIR"
	rm -rf "$MYTMPDIR" 2>/dev/null
}

trap tidy_up EXIT

if [[ $# -eq 1  && "$1" != "-h" && "$1" != "--help" ]] ; then
	mkdir $MYTMPDIR || fail_fat "Unable to create tmp directory $MYTMPDIR"
	cd $MYTMPDIR || fail_fat "Unable to chdir to $MYTMPDIR"
	TOPTARGET="$DWARFG_DIR_WEB/customized_agents/$1"
	[ -d "$TOPTARGET" ] || mkdir -p "$TOPTARGET"
	for i in "$BINDIR/agents"/*/*tgz; do
		LASTDIR=$(dirname ${i#$BINDIR/agents/})
		[ -d "$TOPTARGET/$LASTDIR" ] || mkdir -p "$TOPTARGET/$LASTDIR"
		ARCHNAME=$(basename "$i")
		mkdir $ACTDIR || fail_fat "Unable to create $ACTDIR"
		cd $ACTDIR || fail_fat "Unable to chdir to $ACTDIR"
		tar xzf "$i";
		find . -name "${SHORTNAME}_agent.sh" -type f -print0 | while IFS= read -r -d '' file; do
			sed -i --follow-symlinks "0,/g_prefdevid=.*/s/g_prefdevid=.*/g_prefdevid=\"$1\"/" "$file"
		done
		tar czf "$TOPTARGET/$LASTDIR/$ARCHNAME" ./*;
		cd .. && rm -r $ACTDIR
	done
else
	echo -e "\n$NAME script to prepare agent for a particular device. Provide device-id as first and only parameter.\n"
fi

