<?php

namespace App\Controller\Admin\System;

use App\Bundles\Sg\DatatablesBundle\Response\DatatableResponse;
use App\Controller\Admin\BaseController;
use App\DataTable\EventLogDatatable;
use App\Entity\EventLog\EventType;
use Doctrine\Persistence\ManagerRegistry;
use Sg\DatatablesBundle\Datatable\DatatableFactory;
use Sg\DatatablesBundle\Datatable\DatatableInterface;
use Sg\DatatablesBundle\Response\DatatableQueryBuilder;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class EventLogController extends BaseController
{
    /**
     * @return Response
     * @throws \Exception
     */
    #[Route(path: '/admin/event-log', name: 'admin_event_log')]
    public function default(Request $request, ManagerRegistry $managerRegistry,
                            DatatableFactory $factory, DatatableResponse $responseService): Response{

        $isAjax = $request->isXmlHttpRequest();
        $this->filter = $request->query->get('column');

        $eventTypes = $managerRegistry->getRepository(EventType::class)->findAll();

        /** @var DatatableInterface $datatable */
        $datatable = $factory->create(EventLogDatatable::class);
        $datatable->buildDatatable(['eventTypes' => $eventTypes]);

        if ($isAjax) {
            $responseService->setDatatable($datatable);

            $requestParams = $this->getDatatableFilter($request, $datatable);
            $datatableQueryBuilder = new DatatableQueryBuilder($requestParams, $datatable);
            $responseService->setDatatableQueryBuilder($datatableQueryBuilder);

            return $responseService->getResponse();
        }

        return $this->render('system/eventLog.html.twig', ['datatable' => $datatable, 'filter' => $this->filter]);

    }

}