<?php

declare(strict_types=1);

namespace App\Entity\Device;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'device_user_modules')]
#[ORM\Entity]
class DeviceUserModule
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var Device
     */
    #[ORM\ManyToOne(targetEntity: Device::class, inversedBy: 'userModules')]
    #[ORM\JoinColumn(name: 'id_device', referencedColumnName: 'id_device')]
    public Device $device;

    /**
     * @var UserModule
     */
    #[ORM\ManyToOne(targetEntity: UserModule::class, inversedBy: 'userModules')]
    #[ORM\JoinColumn(name: 'module', referencedColumnName: 'id')]
    public UserModule $userModule;

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return Device
     */
    public function getDevice(): Device {

        return $this->device;

    }

    /**
     * @return UserModule
     */
    public function getUserModule(): UserModule {

        return $this->userModule;

    }

}