<?php

namespace App\Form;

use App\Entity\MonitoringGroup\MonitoringGroup;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class MonitoringGroupType extends AbstractType
{

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options){

        $builder
            ->add('name', TextType::class, ['block_prefix' => 'modal_body'])
            ->add('save', SubmitType::class, ['label' => 'Create Monitoring Group',
                'block_prefix' => 'modal_footer'])
        ;
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver){

        $resolver->setDefaults([
            'data_class' => MonitoringGroup::class,
        ]);

    }

}