<?php

namespace App\Form\Snmp;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;

class SnmpDeviceType extends AbstractType
{

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {

        $builder
            ->add('address', TextType::class, ['block_prefix' => 'modal_body'])
            ->add('communityString', TextType::class, ['block_prefix' => 'modal_body'])
            ->add('protocolVersion', ChoiceType::class, [
                'label' => 'Protocol Version',
                'required' => true,
                'choices' => [1 => '1', 2 => '2'],
                'placeholder' => 'Select a Version',
                'data' => $options['data']['protocolVersion'] ?? null,
                'mapped' => false,
                'auto_initialize' => false,
                'attr' => ['data-raw-class' => 'snmp_device[protocolVersion]'], //Important to setup to send data from the form
                'block_prefix' => 'modal_body'
            ])
            ->add('add', SubmitType::class, ['label' => 'Add Snmp Device',
                'block_prefix' => 'modal_footer'])
        ;
    }

}